package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrivateLinkAccessBuilder extends PrivateLinkAccessFluentImpl<PrivateLinkAccessBuilder> implements VisitableBuilder<PrivateLinkAccess,PrivateLinkAccessBuilder>{
  public PrivateLinkAccessBuilder() {
    this(false);
  }
  public PrivateLinkAccessBuilder(Boolean validationEnabled) {
    this(new PrivateLinkAccess(), validationEnabled);
  }
  public PrivateLinkAccessBuilder(PrivateLinkAccessFluent<?> fluent) {
    this(fluent, false);
  }
  public PrivateLinkAccessBuilder(PrivateLinkAccessFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrivateLinkAccess(), validationEnabled);
  }
  public PrivateLinkAccessBuilder(PrivateLinkAccessFluent<?> fluent,PrivateLinkAccess instance) {
    this(fluent, instance, false);
  }
  public PrivateLinkAccessBuilder(PrivateLinkAccessFluent<?> fluent,PrivateLinkAccess instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnabled(instance.getEnabled()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PrivateLinkAccessBuilder(PrivateLinkAccess instance) {
    this(instance,false);
  }
  public PrivateLinkAccessBuilder(PrivateLinkAccess instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnabled(instance.getEnabled()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PrivateLinkAccessFluent<?> fluent;
  Boolean validationEnabled;
  public PrivateLinkAccess build() {
    PrivateLinkAccess buildable = new PrivateLinkAccess(fluent.getEnabled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}