package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VPCEndpointServiceBuilder extends VPCEndpointServiceFluentImpl<VPCEndpointServiceBuilder> implements VisitableBuilder<VPCEndpointService,VPCEndpointServiceBuilder>{
  public VPCEndpointServiceBuilder() {
    this(false);
  }
  public VPCEndpointServiceBuilder(Boolean validationEnabled) {
    this(new VPCEndpointService(), validationEnabled);
  }
  public VPCEndpointServiceBuilder(VPCEndpointServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public VPCEndpointServiceBuilder(VPCEndpointServiceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VPCEndpointService(), validationEnabled);
  }
  public VPCEndpointServiceBuilder(VPCEndpointServiceFluent<?> fluent,VPCEndpointService instance) {
    this(fluent, instance, false);
  }
  public VPCEndpointServiceBuilder(VPCEndpointServiceFluent<?> fluent,VPCEndpointService instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withId(instance.getId()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VPCEndpointServiceBuilder(VPCEndpointService instance) {
    this(instance,false);
  }
  public VPCEndpointServiceBuilder(VPCEndpointService instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withId(instance.getId()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VPCEndpointServiceFluent<?> fluent;
  Boolean validationEnabled;
  public VPCEndpointService build() {
    VPCEndpointService buildable = new VPCEndpointService(fluent.getId(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}