package io.fabric8.openshift.api.model.hive.ovirt.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>> extends BaseFluent<A> implements MachinePoolFluent<A>{
  public MachinePoolFluentImpl() {
  }
  public MachinePoolFluentImpl(MachinePool instance) {
    this.withCpu(instance.getCpu()); 
    this.withMemoryMB(instance.getMemoryMB()); 
    this.withOsDisk(instance.getOsDisk()); 
    this.withVmType(instance.getVmType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private CPUBuilder cpu;
  private Integer memoryMB;
  private DiskBuilder osDisk;
  private String vmType;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCpu instead.
   * @return The buildable object.
   */
  @Deprecated
  public CPU getCpu() {
    return this.cpu!=null ?this.cpu.build():null;
  }
  public CPU buildCpu() {
    return this.cpu!=null ?this.cpu.build():null;
  }
  public A withCpu(CPU cpu) {
    _visitables.get("cpu").remove(this.cpu);
    if (cpu!=null){ this.cpu= new CPUBuilder(cpu); _visitables.get("cpu").add(this.cpu);} else { this.cpu = null; _visitables.get("cpu").remove(this.cpu); } return (A) this;
  }
  public Boolean hasCpu() {
    return this.cpu != null;
  }
  public A withNewCpu(Integer cores,Integer sockets) {
    return (A)withCpu(new CPU(cores, sockets));
  }
  public MachinePoolFluent.CpuNested<A> withNewCpu() {
    return new MachinePoolFluentImpl.CpuNestedImpl();
  }
  public MachinePoolFluent.CpuNested<A> withNewCpuLike(CPU item) {
    return new MachinePoolFluentImpl.CpuNestedImpl(item);
  }
  public MachinePoolFluent.CpuNested<A> editCpu() {
    return withNewCpuLike(getCpu());
  }
  public MachinePoolFluent.CpuNested<A> editOrNewCpu() {
    return withNewCpuLike(getCpu() != null ? getCpu(): new CPUBuilder().build());
  }
  public MachinePoolFluent.CpuNested<A> editOrNewCpuLike(CPU item) {
    return withNewCpuLike(getCpu() != null ? getCpu(): item);
  }
  public Integer getMemoryMB() {
    return this.memoryMB;
  }
  public A withMemoryMB(Integer memoryMB) {
    this.memoryMB=memoryMB; return (A) this;
  }
  public Boolean hasMemoryMB() {
    return this.memoryMB != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOsDisk instead.
   * @return The buildable object.
   */
  @Deprecated
  public Disk getOsDisk() {
    return this.osDisk!=null ?this.osDisk.build():null;
  }
  public Disk buildOsDisk() {
    return this.osDisk!=null ?this.osDisk.build():null;
  }
  public A withOsDisk(Disk osDisk) {
    _visitables.get("osDisk").remove(this.osDisk);
    if (osDisk!=null){ this.osDisk= new DiskBuilder(osDisk); _visitables.get("osDisk").add(this.osDisk);} else { this.osDisk = null; _visitables.get("osDisk").remove(this.osDisk); } return (A) this;
  }
  public Boolean hasOsDisk() {
    return this.osDisk != null;
  }
  public A withNewOsDisk(Long sizeGB) {
    return (A)withOsDisk(new Disk(sizeGB));
  }
  public MachinePoolFluent.OsDiskNested<A> withNewOsDisk() {
    return new MachinePoolFluentImpl.OsDiskNestedImpl();
  }
  public MachinePoolFluent.OsDiskNested<A> withNewOsDiskLike(Disk item) {
    return new MachinePoolFluentImpl.OsDiskNestedImpl(item);
  }
  public MachinePoolFluent.OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(getOsDisk());
  }
  public MachinePoolFluent.OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(getOsDisk() != null ? getOsDisk(): new DiskBuilder().build());
  }
  public MachinePoolFluent.OsDiskNested<A> editOrNewOsDiskLike(Disk item) {
    return withNewOsDiskLike(getOsDisk() != null ? getOsDisk(): item);
  }
  public String getVmType() {
    return this.vmType;
  }
  public A withVmType(String vmType) {
    this.vmType=vmType; return (A) this;
  }
  public Boolean hasVmType() {
    return this.vmType != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachinePoolFluentImpl that = (MachinePoolFluentImpl) o;
    if (cpu != null ? !cpu.equals(that.cpu) :that.cpu != null) return false;
    if (memoryMB != null ? !memoryMB.equals(that.memoryMB) :that.memoryMB != null) return false;
    if (osDisk != null ? !osDisk.equals(that.osDisk) :that.osDisk != null) return false;
    if (vmType != null ? !vmType.equals(that.vmType) :that.vmType != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cpu,  memoryMB,  osDisk,  vmType,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cpu != null) { sb.append("cpu:"); sb.append(cpu + ","); }
    if (memoryMB != null) { sb.append("memoryMB:"); sb.append(memoryMB + ","); }
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (vmType != null) { sb.append("vmType:"); sb.append(vmType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CpuNestedImpl<N> extends CPUFluentImpl<MachinePoolFluent.CpuNested<N>> implements MachinePoolFluent.CpuNested<N>,Nested<N>{
    CpuNestedImpl(CPU item) {
      this.builder = new CPUBuilder(this, item);
    }
    CpuNestedImpl() {
      this.builder = new CPUBuilder(this);
    }
    CPUBuilder builder;
    public N and() {
      return (N) MachinePoolFluentImpl.this.withCpu(builder.build());
    }
    public N endCpu() {
      return and();
    }
    
  }
  class OsDiskNestedImpl<N> extends DiskFluentImpl<MachinePoolFluent.OsDiskNested<N>> implements MachinePoolFluent.OsDiskNested<N>,Nested<N>{
    OsDiskNestedImpl(Disk item) {
      this.builder = new DiskBuilder(this, item);
    }
    OsDiskNestedImpl() {
      this.builder = new DiskBuilder(this);
    }
    DiskBuilder builder;
    public N and() {
      return (N) MachinePoolFluentImpl.this.withOsDisk(builder.build());
    }
    public N endOsDisk() {
      return and();
    }
    
  }
  
}