package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterClaimStatusBuilder extends ClusterClaimStatusFluentImpl<ClusterClaimStatusBuilder> implements VisitableBuilder<ClusterClaimStatus,ClusterClaimStatusBuilder>{
  public ClusterClaimStatusBuilder() {
    this(false);
  }
  public ClusterClaimStatusBuilder(Boolean validationEnabled) {
    this(new ClusterClaimStatus(), validationEnabled);
  }
  public ClusterClaimStatusBuilder(ClusterClaimStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterClaimStatusBuilder(ClusterClaimStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterClaimStatus(), validationEnabled);
  }
  public ClusterClaimStatusBuilder(ClusterClaimStatusFluent<?> fluent,ClusterClaimStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterClaimStatusBuilder(ClusterClaimStatusFluent<?> fluent,ClusterClaimStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withLifetime(instance.getLifetime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterClaimStatusBuilder(ClusterClaimStatus instance) {
    this(instance,false);
  }
  public ClusterClaimStatusBuilder(ClusterClaimStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withLifetime(instance.getLifetime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterClaimStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterClaimStatus build() {
    ClusterClaimStatus buildable = new ClusterClaimStatus(fluent.getConditions(),fluent.getLifetime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}