package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeploymentBuilder extends ClusterDeploymentFluentImpl<ClusterDeploymentBuilder> implements VisitableBuilder<ClusterDeployment,ClusterDeploymentBuilder>{
  public ClusterDeploymentBuilder() {
    this(false);
  }
  public ClusterDeploymentBuilder(Boolean validationEnabled) {
    this(new ClusterDeployment(), validationEnabled);
  }
  public ClusterDeploymentBuilder(ClusterDeploymentFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeploymentBuilder(ClusterDeploymentFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeployment(), validationEnabled);
  }
  public ClusterDeploymentBuilder(ClusterDeploymentFluent<?> fluent,ClusterDeployment instance) {
    this(fluent, instance, false);
  }
  public ClusterDeploymentBuilder(ClusterDeploymentFluent<?> fluent,ClusterDeployment instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeploymentBuilder(ClusterDeployment instance) {
    this(instance,false);
  }
  public ClusterDeploymentBuilder(ClusterDeployment instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterDeploymentFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeployment build() {
    ClusterDeployment buildable = new ClusterDeployment(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}