package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

 /**
  * Generated
  */
public interface ClusterPoolSpecFluent<A extends ClusterPoolSpecFluent<A>> extends Fluent<A>{
  public A addToAnnotations(String key,String value);
  public A addToAnnotations(Map<String,String> map);
  public A removeFromAnnotations(String key);
  public A removeFromAnnotations(Map<String,String> map);
  public Map<String,String> getAnnotations();
  public <K,V>A withAnnotations(Map<String,String> annotations);
  public Boolean hasAnnotations();
  public String getBaseDomain();
  public A withBaseDomain(String baseDomain);
  public Boolean hasBaseDomain();
  
  /**
   * This method has been deprecated, please use method buildClaimLifetime instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterPoolClaimLifetime getClaimLifetime();
  public ClusterPoolClaimLifetime buildClaimLifetime();
  public A withClaimLifetime(ClusterPoolClaimLifetime claimLifetime);
  public Boolean hasClaimLifetime();
  public ClusterPoolSpecFluent.ClaimLifetimeNested<A> withNewClaimLifetime();
  public ClusterPoolSpecFluent.ClaimLifetimeNested<A> withNewClaimLifetimeLike(ClusterPoolClaimLifetime item);
  public ClusterPoolSpecFluent.ClaimLifetimeNested<A> editClaimLifetime();
  public ClusterPoolSpecFluent.ClaimLifetimeNested<A> editOrNewClaimLifetime();
  public ClusterPoolSpecFluent.ClaimLifetimeNested<A> editOrNewClaimLifetimeLike(ClusterPoolClaimLifetime item);
  public Duration getHibernateAfter();
  public A withHibernateAfter(Duration hibernateAfter);
  public Boolean hasHibernateAfter();
  
  /**
   * This method has been deprecated, please use method buildImageSetRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterImageSetReference getImageSetRef();
  public ClusterImageSetReference buildImageSetRef();
  public A withImageSetRef(ClusterImageSetReference imageSetRef);
  public Boolean hasImageSetRef();
  public A withNewImageSetRef(String name);
  public ClusterPoolSpecFluent.ImageSetRefNested<A> withNewImageSetRef();
  public ClusterPoolSpecFluent.ImageSetRefNested<A> withNewImageSetRefLike(ClusterImageSetReference item);
  public ClusterPoolSpecFluent.ImageSetRefNested<A> editImageSetRef();
  public ClusterPoolSpecFluent.ImageSetRefNested<A> editOrNewImageSetRef();
  public ClusterPoolSpecFluent.ImageSetRefNested<A> editOrNewImageSetRefLike(ClusterImageSetReference item);
  public Integer getInstallAttemptsLimit();
  public A withInstallAttemptsLimit(Integer installAttemptsLimit);
  public Boolean hasInstallAttemptsLimit();
  
  /**
   * This method has been deprecated, please use method buildInstallConfigSecretTemplateRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getInstallConfigSecretTemplateRef();
  public LocalObjectReference buildInstallConfigSecretTemplateRef();
  public A withInstallConfigSecretTemplateRef(LocalObjectReference installConfigSecretTemplateRef);
  public Boolean hasInstallConfigSecretTemplateRef();
  public A withNewInstallConfigSecretTemplateRef(String name);
  public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRef();
  public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRefLike(LocalObjectReference item);
  public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> editInstallConfigSecretTemplateRef();
  public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRef();
  public ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRefLike(LocalObjectReference item);
  public A addToLabels(String key,String value);
  public A addToLabels(Map<String,String> map);
  public A removeFromLabels(String key);
  public A removeFromLabels(Map<String,String> map);
  public Map<String,String> getLabels();
  public <K,V>A withLabels(Map<String,String> labels);
  public Boolean hasLabels();
  public Integer getMaxConcurrent();
  public A withMaxConcurrent(Integer maxConcurrent);
  public Boolean hasMaxConcurrent();
  public Integer getMaxSize();
  public A withMaxSize(Integer maxSize);
  public Boolean hasMaxSize();
  
  /**
   * This method has been deprecated, please use method buildPlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public Platform getPlatform();
  public Platform buildPlatform();
  public A withPlatform(Platform platform);
  public Boolean hasPlatform();
  public ClusterPoolSpecFluent.PlatformNested<A> withNewPlatform();
  public ClusterPoolSpecFluent.PlatformNested<A> withNewPlatformLike(Platform item);
  public ClusterPoolSpecFluent.PlatformNested<A> editPlatform();
  public ClusterPoolSpecFluent.PlatformNested<A> editOrNewPlatform();
  public ClusterPoolSpecFluent.PlatformNested<A> editOrNewPlatformLike(Platform item);
  
  /**
   * This method has been deprecated, please use method buildPullSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPullSecretRef();
  public LocalObjectReference buildPullSecretRef();
  public A withPullSecretRef(LocalObjectReference pullSecretRef);
  public Boolean hasPullSecretRef();
  public A withNewPullSecretRef(String name);
  public ClusterPoolSpecFluent.PullSecretRefNested<A> withNewPullSecretRef();
  public ClusterPoolSpecFluent.PullSecretRefNested<A> withNewPullSecretRefLike(LocalObjectReference item);
  public ClusterPoolSpecFluent.PullSecretRefNested<A> editPullSecretRef();
  public ClusterPoolSpecFluent.PullSecretRefNested<A> editOrNewPullSecretRef();
  public ClusterPoolSpecFluent.PullSecretRefNested<A> editOrNewPullSecretRefLike(LocalObjectReference item);
  public Integer getRunningCount();
  public A withRunningCount(Integer runningCount);
  public Boolean hasRunningCount();
  public Integer getSize();
  public A withSize(Integer size);
  public Boolean hasSize();
  public Boolean getSkipMachinePools();
  public A withSkipMachinePools(Boolean skipMachinePools);
  public Boolean hasSkipMachinePools();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withSkipMachinePools();
  public interface ClaimLifetimeNested<N> extends Nested<N>,ClusterPoolClaimLifetimeFluent<ClusterPoolSpecFluent.ClaimLifetimeNested<N>>{
    public N and();
    public N endClaimLifetime();
    
  }
  public interface ImageSetRefNested<N> extends Nested<N>,ClusterImageSetReferenceFluent<ClusterPoolSpecFluent.ImageSetRefNested<N>>{
    public N and();
    public N endImageSetRef();
    
  }
  public interface InstallConfigSecretTemplateRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<ClusterPoolSpecFluent.InstallConfigSecretTemplateRefNested<N>>{
    public N and();
    public N endInstallConfigSecretTemplateRef();
    
  }
  public interface PlatformNested<N> extends Nested<N>,PlatformFluent<ClusterPoolSpecFluent.PlatformNested<N>>{
    public N and();
    public N endPlatform();
    
  }
  public interface PullSecretRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<ClusterPoolSpecFluent.PullSecretRefNested<N>>{
    public N and();
    public N endPullSecretRef();
    
  }
  
}