package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HiveConfigSpecFluentImpl<A extends HiveConfigSpecFluent<A>> extends BaseFluent<A> implements HiveConfigSpecFluent<A>{
  public HiveConfigSpecFluentImpl() {
  }
  public HiveConfigSpecFluentImpl(HiveConfigSpec instance) {
    this.withAdditionalCertificateAuthoritiesSecretRef(instance.getAdditionalCertificateAuthoritiesSecretRef()); 
    this.withArgoCDConfig(instance.getArgoCDConfig()); 
    this.withAwsPrivateLink(instance.getAwsPrivateLink()); 
    this.withBackup(instance.getBackup()); 
    this.withControllersConfig(instance.getControllersConfig()); 
    this.withDeleteProtection(instance.getDeleteProtection()); 
    this.withDeprovisionsDisabled(instance.getDeprovisionsDisabled()); 
    this.withDisabledControllers(instance.getDisabledControllers()); 
    this.withExportMetrics(instance.getExportMetrics()); 
    this.withFailedProvisionConfig(instance.getFailedProvisionConfig()); 
    this.withFeatureGates(instance.getFeatureGates()); 
    this.withGlobalPullSecretRef(instance.getGlobalPullSecretRef()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withMaintenanceMode(instance.getMaintenanceMode()); 
    this.withManagedDomains(instance.getManagedDomains()); 
    this.withReleaseImageVerificationConfigMapRef(instance.getReleaseImageVerificationConfigMapRef()); 
    this.withServiceProviderCredentialsConfig(instance.getServiceProviderCredentialsConfig()); 
    this.withSyncSetReapplyInterval(instance.getSyncSetReapplyInterval()); 
    this.withTargetNamespace(instance.getTargetNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<LocalObjectReferenceBuilder> additionalCertificateAuthoritiesSecretRef = new ArrayList<LocalObjectReferenceBuilder>();
  private ArgoCDConfigBuilder argoCDConfig;
  private AWSPrivateLinkConfigBuilder awsPrivateLink;
  private BackupConfigBuilder backup;
  private ControllersConfigBuilder controllersConfig;
  private String deleteProtection;
  private Boolean deprovisionsDisabled;
  private List<String> disabledControllers = new ArrayList<String>();
  private Boolean exportMetrics;
  private FailedProvisionConfigBuilder failedProvisionConfig;
  private FeatureGateSelectionBuilder featureGates;
  private LocalObjectReferenceBuilder globalPullSecretRef;
  private String logLevel;
  private Boolean maintenanceMode;
  private ArrayList<ManageDNSConfigBuilder> managedDomains = new ArrayList<ManageDNSConfigBuilder>();
  private ReleaseImageVerificationConfigMapReferenceBuilder releaseImageVerificationConfigMapRef;
  private ServiceProviderCredentialsBuilder serviceProviderCredentialsConfig;
  private String syncSetReapplyInterval;
  private String targetNamespace;
  private Map<String,Object> additionalProperties;
  public A addToAdditionalCertificateAuthoritiesSecretRef(Integer index,LocalObjectReference item) {
    if (this.additionalCertificateAuthoritiesSecretRef == null) {this.additionalCertificateAuthoritiesSecretRef = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthoritiesSecretRef").add(index >= 0 ? index : _visitables.get("additionalCertificateAuthoritiesSecretRef").size(), builder);this.additionalCertificateAuthoritiesSecretRef.add(index >= 0 ? index : additionalCertificateAuthoritiesSecretRef.size(), builder); return (A)this;
  }
  public A setToAdditionalCertificateAuthoritiesSecretRef(Integer index,LocalObjectReference item) {
    if (this.additionalCertificateAuthoritiesSecretRef == null) {this.additionalCertificateAuthoritiesSecretRef = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("additionalCertificateAuthoritiesSecretRef").size()) { _visitables.get("additionalCertificateAuthoritiesSecretRef").add(builder); } else { _visitables.get("additionalCertificateAuthoritiesSecretRef").set(index, builder);}
    if (index < 0 || index >= additionalCertificateAuthoritiesSecretRef.size()) { additionalCertificateAuthoritiesSecretRef.add(builder); } else { additionalCertificateAuthoritiesSecretRef.set(index, builder);}
     return (A)this;
  }
  public A addToAdditionalCertificateAuthoritiesSecretRef(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.additionalCertificateAuthoritiesSecretRef == null) {this.additionalCertificateAuthoritiesSecretRef = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthoritiesSecretRef").add(builder);this.additionalCertificateAuthoritiesSecretRef.add(builder);} return (A)this;
  }
  public A addAllToAdditionalCertificateAuthoritiesSecretRef(Collection<LocalObjectReference> items) {
    if (this.additionalCertificateAuthoritiesSecretRef == null) {this.additionalCertificateAuthoritiesSecretRef = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthoritiesSecretRef").add(builder);this.additionalCertificateAuthoritiesSecretRef.add(builder);} return (A)this;
  }
  public A removeFromAdditionalCertificateAuthoritiesSecretRef(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthoritiesSecretRef").remove(builder);if (this.additionalCertificateAuthoritiesSecretRef != null) {this.additionalCertificateAuthoritiesSecretRef.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalCertificateAuthoritiesSecretRef(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("additionalCertificateAuthoritiesSecretRef").remove(builder);if (this.additionalCertificateAuthoritiesSecretRef != null) {this.additionalCertificateAuthoritiesSecretRef.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalCertificateAuthoritiesSecretRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (additionalCertificateAuthoritiesSecretRef == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = additionalCertificateAuthoritiesSecretRef.iterator();
    final List visitables = _visitables.get("additionalCertificateAuthoritiesSecretRef");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalCertificateAuthoritiesSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getAdditionalCertificateAuthoritiesSecretRef() {
    return additionalCertificateAuthoritiesSecretRef != null ? build(additionalCertificateAuthoritiesSecretRef) : null;
  }
  public List<LocalObjectReference> buildAdditionalCertificateAuthoritiesSecretRef() {
    return additionalCertificateAuthoritiesSecretRef != null ? build(additionalCertificateAuthoritiesSecretRef) : null;
  }
  public LocalObjectReference buildAdditionalCertificateAuthoritiesSecretRef(Integer index) {
    return this.additionalCertificateAuthoritiesSecretRef.get(index).build();
  }
  public LocalObjectReference buildFirstAdditionalCertificateAuthoritiesSecretRef() {
    return this.additionalCertificateAuthoritiesSecretRef.get(0).build();
  }
  public LocalObjectReference buildLastAdditionalCertificateAuthoritiesSecretRef() {
    return this.additionalCertificateAuthoritiesSecretRef.get(additionalCertificateAuthoritiesSecretRef.size() - 1).build();
  }
  public LocalObjectReference buildMatchingAdditionalCertificateAuthoritiesSecretRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: additionalCertificateAuthoritiesSecretRef) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAdditionalCertificateAuthoritiesSecretRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: additionalCertificateAuthoritiesSecretRef) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalCertificateAuthoritiesSecretRef(List<LocalObjectReference> additionalCertificateAuthoritiesSecretRef) {
    if (this.additionalCertificateAuthoritiesSecretRef != null) { _visitables.get("additionalCertificateAuthoritiesSecretRef").removeAll(this.additionalCertificateAuthoritiesSecretRef);}
    if (additionalCertificateAuthoritiesSecretRef != null) {this.additionalCertificateAuthoritiesSecretRef = new ArrayList(); for (LocalObjectReference item : additionalCertificateAuthoritiesSecretRef){this.addToAdditionalCertificateAuthoritiesSecretRef(item);}} else { this.additionalCertificateAuthoritiesSecretRef = null;} return (A) this;
  }
  public A withAdditionalCertificateAuthoritiesSecretRef(io.fabric8.kubernetes.api.model.LocalObjectReference... additionalCertificateAuthoritiesSecretRef) {
    if (this.additionalCertificateAuthoritiesSecretRef != null) {this.additionalCertificateAuthoritiesSecretRef.clear();}
    if (additionalCertificateAuthoritiesSecretRef != null) {for (LocalObjectReference item :additionalCertificateAuthoritiesSecretRef){ this.addToAdditionalCertificateAuthoritiesSecretRef(item);}} return (A) this;
  }
  public Boolean hasAdditionalCertificateAuthoritiesSecretRef() {
    return additionalCertificateAuthoritiesSecretRef != null && !additionalCertificateAuthoritiesSecretRef.isEmpty();
  }
  public A addNewAdditionalCertificateAuthoritiesSecretRef(String name) {
    return (A)addToAdditionalCertificateAuthoritiesSecretRef(new LocalObjectReference(name));
  }
  public HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<A> addNewAdditionalCertificateAuthoritiesSecretRef() {
    return new HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesSecretRefNestedImpl();
  }
  public HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<A> addNewAdditionalCertificateAuthoritiesSecretRefLike(LocalObjectReference item) {
    return new HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesSecretRefNestedImpl(-1, item);
  }
  public HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<A> setNewAdditionalCertificateAuthoritiesSecretRefLike(Integer index,LocalObjectReference item) {
    return new HiveConfigSpecFluentImpl.AdditionalCertificateAuthoritiesSecretRefNestedImpl(index, item);
  }
  public HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<A> editAdditionalCertificateAuthoritiesSecretRef(Integer index) {
    if (additionalCertificateAuthoritiesSecretRef.size() <= index) throw new RuntimeException("Can't edit additionalCertificateAuthoritiesSecretRef. Index exceeds size.");
    return setNewAdditionalCertificateAuthoritiesSecretRefLike(index, buildAdditionalCertificateAuthoritiesSecretRef(index));
  }
  public HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<A> editFirstAdditionalCertificateAuthoritiesSecretRef() {
    if (additionalCertificateAuthoritiesSecretRef.size() == 0) throw new RuntimeException("Can't edit first additionalCertificateAuthoritiesSecretRef. The list is empty.");
    return setNewAdditionalCertificateAuthoritiesSecretRefLike(0, buildAdditionalCertificateAuthoritiesSecretRef(0));
  }
  public HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<A> editLastAdditionalCertificateAuthoritiesSecretRef() {
    int index = additionalCertificateAuthoritiesSecretRef.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalCertificateAuthoritiesSecretRef. The list is empty.");
    return setNewAdditionalCertificateAuthoritiesSecretRefLike(index, buildAdditionalCertificateAuthoritiesSecretRef(index));
  }
  public HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<A> editMatchingAdditionalCertificateAuthoritiesSecretRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalCertificateAuthoritiesSecretRef.size();i++) { 
    if (predicate.test(additionalCertificateAuthoritiesSecretRef.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalCertificateAuthoritiesSecretRef. No match found.");
    return setNewAdditionalCertificateAuthoritiesSecretRefLike(index, buildAdditionalCertificateAuthoritiesSecretRef(index));
  }
  
  /**
   * This method has been deprecated, please use method buildArgoCDConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ArgoCDConfig getArgoCDConfig() {
    return this.argoCDConfig!=null ?this.argoCDConfig.build():null;
  }
  public ArgoCDConfig buildArgoCDConfig() {
    return this.argoCDConfig!=null ?this.argoCDConfig.build():null;
  }
  public A withArgoCDConfig(ArgoCDConfig argoCDConfig) {
    _visitables.get("argoCDConfig").remove(this.argoCDConfig);
    if (argoCDConfig!=null){ this.argoCDConfig= new ArgoCDConfigBuilder(argoCDConfig); _visitables.get("argoCDConfig").add(this.argoCDConfig);} else { this.argoCDConfig = null; _visitables.get("argoCDConfig").remove(this.argoCDConfig); } return (A) this;
  }
  public Boolean hasArgoCDConfig() {
    return this.argoCDConfig != null;
  }
  public A withNewArgoCDConfig(Boolean enabled,String namespace) {
    return (A)withArgoCDConfig(new ArgoCDConfig(enabled, namespace));
  }
  public HiveConfigSpecFluent.ArgoCDConfigNested<A> withNewArgoCDConfig() {
    return new HiveConfigSpecFluentImpl.ArgoCDConfigNestedImpl();
  }
  public HiveConfigSpecFluent.ArgoCDConfigNested<A> withNewArgoCDConfigLike(ArgoCDConfig item) {
    return new HiveConfigSpecFluentImpl.ArgoCDConfigNestedImpl(item);
  }
  public HiveConfigSpecFluent.ArgoCDConfigNested<A> editArgoCDConfig() {
    return withNewArgoCDConfigLike(getArgoCDConfig());
  }
  public HiveConfigSpecFluent.ArgoCDConfigNested<A> editOrNewArgoCDConfig() {
    return withNewArgoCDConfigLike(getArgoCDConfig() != null ? getArgoCDConfig(): new ArgoCDConfigBuilder().build());
  }
  public HiveConfigSpecFluent.ArgoCDConfigNested<A> editOrNewArgoCDConfigLike(ArgoCDConfig item) {
    return withNewArgoCDConfigLike(getArgoCDConfig() != null ? getArgoCDConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAwsPrivateLink instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSPrivateLinkConfig getAwsPrivateLink() {
    return this.awsPrivateLink!=null ?this.awsPrivateLink.build():null;
  }
  public AWSPrivateLinkConfig buildAwsPrivateLink() {
    return this.awsPrivateLink!=null ?this.awsPrivateLink.build():null;
  }
  public A withAwsPrivateLink(AWSPrivateLinkConfig awsPrivateLink) {
    _visitables.get("awsPrivateLink").remove(this.awsPrivateLink);
    if (awsPrivateLink!=null){ this.awsPrivateLink= new AWSPrivateLinkConfigBuilder(awsPrivateLink); _visitables.get("awsPrivateLink").add(this.awsPrivateLink);} else { this.awsPrivateLink = null; _visitables.get("awsPrivateLink").remove(this.awsPrivateLink); } return (A) this;
  }
  public Boolean hasAwsPrivateLink() {
    return this.awsPrivateLink != null;
  }
  public HiveConfigSpecFluent.AwsPrivateLinkNested<A> withNewAwsPrivateLink() {
    return new HiveConfigSpecFluentImpl.AwsPrivateLinkNestedImpl();
  }
  public HiveConfigSpecFluent.AwsPrivateLinkNested<A> withNewAwsPrivateLinkLike(AWSPrivateLinkConfig item) {
    return new HiveConfigSpecFluentImpl.AwsPrivateLinkNestedImpl(item);
  }
  public HiveConfigSpecFluent.AwsPrivateLinkNested<A> editAwsPrivateLink() {
    return withNewAwsPrivateLinkLike(getAwsPrivateLink());
  }
  public HiveConfigSpecFluent.AwsPrivateLinkNested<A> editOrNewAwsPrivateLink() {
    return withNewAwsPrivateLinkLike(getAwsPrivateLink() != null ? getAwsPrivateLink(): new AWSPrivateLinkConfigBuilder().build());
  }
  public HiveConfigSpecFluent.AwsPrivateLinkNested<A> editOrNewAwsPrivateLinkLike(AWSPrivateLinkConfig item) {
    return withNewAwsPrivateLinkLike(getAwsPrivateLink() != null ? getAwsPrivateLink(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBackup instead.
   * @return The buildable object.
   */
  @Deprecated
  public BackupConfig getBackup() {
    return this.backup!=null ?this.backup.build():null;
  }
  public BackupConfig buildBackup() {
    return this.backup!=null ?this.backup.build():null;
  }
  public A withBackup(BackupConfig backup) {
    _visitables.get("backup").remove(this.backup);
    if (backup!=null){ this.backup= new BackupConfigBuilder(backup); _visitables.get("backup").add(this.backup);} else { this.backup = null; _visitables.get("backup").remove(this.backup); } return (A) this;
  }
  public Boolean hasBackup() {
    return this.backup != null;
  }
  public HiveConfigSpecFluent.BackupNested<A> withNewBackup() {
    return new HiveConfigSpecFluentImpl.BackupNestedImpl();
  }
  public HiveConfigSpecFluent.BackupNested<A> withNewBackupLike(BackupConfig item) {
    return new HiveConfigSpecFluentImpl.BackupNestedImpl(item);
  }
  public HiveConfigSpecFluent.BackupNested<A> editBackup() {
    return withNewBackupLike(getBackup());
  }
  public HiveConfigSpecFluent.BackupNested<A> editOrNewBackup() {
    return withNewBackupLike(getBackup() != null ? getBackup(): new BackupConfigBuilder().build());
  }
  public HiveConfigSpecFluent.BackupNested<A> editOrNewBackupLike(BackupConfig item) {
    return withNewBackupLike(getBackup() != null ? getBackup(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildControllersConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ControllersConfig getControllersConfig() {
    return this.controllersConfig!=null ?this.controllersConfig.build():null;
  }
  public ControllersConfig buildControllersConfig() {
    return this.controllersConfig!=null ?this.controllersConfig.build():null;
  }
  public A withControllersConfig(ControllersConfig controllersConfig) {
    _visitables.get("controllersConfig").remove(this.controllersConfig);
    if (controllersConfig!=null){ this.controllersConfig= new ControllersConfigBuilder(controllersConfig); _visitables.get("controllersConfig").add(this.controllersConfig);} else { this.controllersConfig = null; _visitables.get("controllersConfig").remove(this.controllersConfig); } return (A) this;
  }
  public Boolean hasControllersConfig() {
    return this.controllersConfig != null;
  }
  public HiveConfigSpecFluent.ControllersConfigNested<A> withNewControllersConfig() {
    return new HiveConfigSpecFluentImpl.ControllersConfigNestedImpl();
  }
  public HiveConfigSpecFluent.ControllersConfigNested<A> withNewControllersConfigLike(ControllersConfig item) {
    return new HiveConfigSpecFluentImpl.ControllersConfigNestedImpl(item);
  }
  public HiveConfigSpecFluent.ControllersConfigNested<A> editControllersConfig() {
    return withNewControllersConfigLike(getControllersConfig());
  }
  public HiveConfigSpecFluent.ControllersConfigNested<A> editOrNewControllersConfig() {
    return withNewControllersConfigLike(getControllersConfig() != null ? getControllersConfig(): new ControllersConfigBuilder().build());
  }
  public HiveConfigSpecFluent.ControllersConfigNested<A> editOrNewControllersConfigLike(ControllersConfig item) {
    return withNewControllersConfigLike(getControllersConfig() != null ? getControllersConfig(): item);
  }
  public String getDeleteProtection() {
    return this.deleteProtection;
  }
  public A withDeleteProtection(String deleteProtection) {
    this.deleteProtection=deleteProtection; return (A) this;
  }
  public Boolean hasDeleteProtection() {
    return this.deleteProtection != null;
  }
  public Boolean getDeprovisionsDisabled() {
    return this.deprovisionsDisabled;
  }
  public A withDeprovisionsDisabled(Boolean deprovisionsDisabled) {
    this.deprovisionsDisabled=deprovisionsDisabled; return (A) this;
  }
  public Boolean hasDeprovisionsDisabled() {
    return this.deprovisionsDisabled != null;
  }
  public A addToDisabledControllers(Integer index,String item) {
    if (this.disabledControllers == null) {this.disabledControllers = new ArrayList<String>();}
    this.disabledControllers.add(index, item);
    return (A)this;
  }
  public A setToDisabledControllers(Integer index,String item) {
    if (this.disabledControllers == null) {this.disabledControllers = new ArrayList<String>();}
    this.disabledControllers.set(index, item); return (A)this;
  }
  public A addToDisabledControllers(java.lang.String... items) {
    if (this.disabledControllers == null) {this.disabledControllers = new ArrayList<String>();}
    for (String item : items) {this.disabledControllers.add(item);} return (A)this;
  }
  public A addAllToDisabledControllers(Collection<String> items) {
    if (this.disabledControllers == null) {this.disabledControllers = new ArrayList<String>();}
    for (String item : items) {this.disabledControllers.add(item);} return (A)this;
  }
  public A removeFromDisabledControllers(java.lang.String... items) {
    for (String item : items) {if (this.disabledControllers!= null){ this.disabledControllers.remove(item);}} return (A)this;
  }
  public A removeAllFromDisabledControllers(Collection<String> items) {
    for (String item : items) {if (this.disabledControllers!= null){ this.disabledControllers.remove(item);}} return (A)this;
  }
  public List<String> getDisabledControllers() {
    return this.disabledControllers;
  }
  public String getDisabledController(Integer index) {
    return this.disabledControllers.get(index);
  }
  public String getFirstDisabledController() {
    return this.disabledControllers.get(0);
  }
  public String getLastDisabledController() {
    return this.disabledControllers.get(disabledControllers.size() - 1);
  }
  public String getMatchingDisabledController(Predicate<String> predicate) {
    for (String item: disabledControllers) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDisabledController(Predicate<String> predicate) {
    for (String item: disabledControllers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDisabledControllers(List<String> disabledControllers) {
    if (disabledControllers != null) {this.disabledControllers = new ArrayList(); for (String item : disabledControllers){this.addToDisabledControllers(item);}} else { this.disabledControllers = null;} return (A) this;
  }
  public A withDisabledControllers(java.lang.String... disabledControllers) {
    if (this.disabledControllers != null) {this.disabledControllers.clear();}
    if (disabledControllers != null) {for (String item :disabledControllers){ this.addToDisabledControllers(item);}} return (A) this;
  }
  public Boolean hasDisabledControllers() {
    return disabledControllers != null && !disabledControllers.isEmpty();
  }
  public Boolean getExportMetrics() {
    return this.exportMetrics;
  }
  public A withExportMetrics(Boolean exportMetrics) {
    this.exportMetrics=exportMetrics; return (A) this;
  }
  public Boolean hasExportMetrics() {
    return this.exportMetrics != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFailedProvisionConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public FailedProvisionConfig getFailedProvisionConfig() {
    return this.failedProvisionConfig!=null ?this.failedProvisionConfig.build():null;
  }
  public FailedProvisionConfig buildFailedProvisionConfig() {
    return this.failedProvisionConfig!=null ?this.failedProvisionConfig.build():null;
  }
  public A withFailedProvisionConfig(FailedProvisionConfig failedProvisionConfig) {
    _visitables.get("failedProvisionConfig").remove(this.failedProvisionConfig);
    if (failedProvisionConfig!=null){ this.failedProvisionConfig= new FailedProvisionConfigBuilder(failedProvisionConfig); _visitables.get("failedProvisionConfig").add(this.failedProvisionConfig);} else { this.failedProvisionConfig = null; _visitables.get("failedProvisionConfig").remove(this.failedProvisionConfig); } return (A) this;
  }
  public Boolean hasFailedProvisionConfig() {
    return this.failedProvisionConfig != null;
  }
  public HiveConfigSpecFluent.FailedProvisionConfigNested<A> withNewFailedProvisionConfig() {
    return new HiveConfigSpecFluentImpl.FailedProvisionConfigNestedImpl();
  }
  public HiveConfigSpecFluent.FailedProvisionConfigNested<A> withNewFailedProvisionConfigLike(FailedProvisionConfig item) {
    return new HiveConfigSpecFluentImpl.FailedProvisionConfigNestedImpl(item);
  }
  public HiveConfigSpecFluent.FailedProvisionConfigNested<A> editFailedProvisionConfig() {
    return withNewFailedProvisionConfigLike(getFailedProvisionConfig());
  }
  public HiveConfigSpecFluent.FailedProvisionConfigNested<A> editOrNewFailedProvisionConfig() {
    return withNewFailedProvisionConfigLike(getFailedProvisionConfig() != null ? getFailedProvisionConfig(): new FailedProvisionConfigBuilder().build());
  }
  public HiveConfigSpecFluent.FailedProvisionConfigNested<A> editOrNewFailedProvisionConfigLike(FailedProvisionConfig item) {
    return withNewFailedProvisionConfigLike(getFailedProvisionConfig() != null ? getFailedProvisionConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFeatureGates instead.
   * @return The buildable object.
   */
  @Deprecated
  public FeatureGateSelection getFeatureGates() {
    return this.featureGates!=null ?this.featureGates.build():null;
  }
  public FeatureGateSelection buildFeatureGates() {
    return this.featureGates!=null ?this.featureGates.build():null;
  }
  public A withFeatureGates(FeatureGateSelection featureGates) {
    _visitables.get("featureGates").remove(this.featureGates);
    if (featureGates!=null){ this.featureGates= new FeatureGateSelectionBuilder(featureGates); _visitables.get("featureGates").add(this.featureGates);} else { this.featureGates = null; _visitables.get("featureGates").remove(this.featureGates); } return (A) this;
  }
  public Boolean hasFeatureGates() {
    return this.featureGates != null;
  }
  public HiveConfigSpecFluent.FeatureGatesNested<A> withNewFeatureGates() {
    return new HiveConfigSpecFluentImpl.FeatureGatesNestedImpl();
  }
  public HiveConfigSpecFluent.FeatureGatesNested<A> withNewFeatureGatesLike(FeatureGateSelection item) {
    return new HiveConfigSpecFluentImpl.FeatureGatesNestedImpl(item);
  }
  public HiveConfigSpecFluent.FeatureGatesNested<A> editFeatureGates() {
    return withNewFeatureGatesLike(getFeatureGates());
  }
  public HiveConfigSpecFluent.FeatureGatesNested<A> editOrNewFeatureGates() {
    return withNewFeatureGatesLike(getFeatureGates() != null ? getFeatureGates(): new FeatureGateSelectionBuilder().build());
  }
  public HiveConfigSpecFluent.FeatureGatesNested<A> editOrNewFeatureGatesLike(FeatureGateSelection item) {
    return withNewFeatureGatesLike(getFeatureGates() != null ? getFeatureGates(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGlobalPullSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getGlobalPullSecretRef() {
    return this.globalPullSecretRef!=null ?this.globalPullSecretRef.build():null;
  }
  public LocalObjectReference buildGlobalPullSecretRef() {
    return this.globalPullSecretRef!=null ?this.globalPullSecretRef.build():null;
  }
  public A withGlobalPullSecretRef(LocalObjectReference globalPullSecretRef) {
    _visitables.get("globalPullSecretRef").remove(this.globalPullSecretRef);
    if (globalPullSecretRef!=null){ this.globalPullSecretRef= new LocalObjectReferenceBuilder(globalPullSecretRef); _visitables.get("globalPullSecretRef").add(this.globalPullSecretRef);} else { this.globalPullSecretRef = null; _visitables.get("globalPullSecretRef").remove(this.globalPullSecretRef); } return (A) this;
  }
  public Boolean hasGlobalPullSecretRef() {
    return this.globalPullSecretRef != null;
  }
  public A withNewGlobalPullSecretRef(String name) {
    return (A)withGlobalPullSecretRef(new LocalObjectReference(name));
  }
  public HiveConfigSpecFluent.GlobalPullSecretRefNested<A> withNewGlobalPullSecretRef() {
    return new HiveConfigSpecFluentImpl.GlobalPullSecretRefNestedImpl();
  }
  public HiveConfigSpecFluent.GlobalPullSecretRefNested<A> withNewGlobalPullSecretRefLike(LocalObjectReference item) {
    return new HiveConfigSpecFluentImpl.GlobalPullSecretRefNestedImpl(item);
  }
  public HiveConfigSpecFluent.GlobalPullSecretRefNested<A> editGlobalPullSecretRef() {
    return withNewGlobalPullSecretRefLike(getGlobalPullSecretRef());
  }
  public HiveConfigSpecFluent.GlobalPullSecretRefNested<A> editOrNewGlobalPullSecretRef() {
    return withNewGlobalPullSecretRefLike(getGlobalPullSecretRef() != null ? getGlobalPullSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public HiveConfigSpecFluent.GlobalPullSecretRefNested<A> editOrNewGlobalPullSecretRefLike(LocalObjectReference item) {
    return withNewGlobalPullSecretRefLike(getGlobalPullSecretRef() != null ? getGlobalPullSecretRef(): item);
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public Boolean getMaintenanceMode() {
    return this.maintenanceMode;
  }
  public A withMaintenanceMode(Boolean maintenanceMode) {
    this.maintenanceMode=maintenanceMode; return (A) this;
  }
  public Boolean hasMaintenanceMode() {
    return this.maintenanceMode != null;
  }
  public A addToManagedDomains(Integer index,ManageDNSConfig item) {
    if (this.managedDomains == null) {this.managedDomains = new ArrayList<ManageDNSConfigBuilder>();}
    ManageDNSConfigBuilder builder = new ManageDNSConfigBuilder(item);_visitables.get("managedDomains").add(index >= 0 ? index : _visitables.get("managedDomains").size(), builder);this.managedDomains.add(index >= 0 ? index : managedDomains.size(), builder); return (A)this;
  }
  public A setToManagedDomains(Integer index,ManageDNSConfig item) {
    if (this.managedDomains == null) {this.managedDomains = new ArrayList<ManageDNSConfigBuilder>();}
    ManageDNSConfigBuilder builder = new ManageDNSConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("managedDomains").size()) { _visitables.get("managedDomains").add(builder); } else { _visitables.get("managedDomains").set(index, builder);}
    if (index < 0 || index >= managedDomains.size()) { managedDomains.add(builder); } else { managedDomains.set(index, builder);}
     return (A)this;
  }
  public A addToManagedDomains(io.fabric8.openshift.api.model.hive.v1.ManageDNSConfig... items) {
    if (this.managedDomains == null) {this.managedDomains = new ArrayList<ManageDNSConfigBuilder>();}
    for (ManageDNSConfig item : items) {ManageDNSConfigBuilder builder = new ManageDNSConfigBuilder(item);_visitables.get("managedDomains").add(builder);this.managedDomains.add(builder);} return (A)this;
  }
  public A addAllToManagedDomains(Collection<ManageDNSConfig> items) {
    if (this.managedDomains == null) {this.managedDomains = new ArrayList<ManageDNSConfigBuilder>();}
    for (ManageDNSConfig item : items) {ManageDNSConfigBuilder builder = new ManageDNSConfigBuilder(item);_visitables.get("managedDomains").add(builder);this.managedDomains.add(builder);} return (A)this;
  }
  public A removeFromManagedDomains(io.fabric8.openshift.api.model.hive.v1.ManageDNSConfig... items) {
    for (ManageDNSConfig item : items) {ManageDNSConfigBuilder builder = new ManageDNSConfigBuilder(item);_visitables.get("managedDomains").remove(builder);if (this.managedDomains != null) {this.managedDomains.remove(builder);}} return (A)this;
  }
  public A removeAllFromManagedDomains(Collection<ManageDNSConfig> items) {
    for (ManageDNSConfig item : items) {ManageDNSConfigBuilder builder = new ManageDNSConfigBuilder(item);_visitables.get("managedDomains").remove(builder);if (this.managedDomains != null) {this.managedDomains.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromManagedDomains(Predicate<ManageDNSConfigBuilder> predicate) {
    if (managedDomains == null) return (A) this;
    final Iterator<ManageDNSConfigBuilder> each = managedDomains.iterator();
    final List visitables = _visitables.get("managedDomains");
    while (each.hasNext()) {
      ManageDNSConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildManagedDomains instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ManageDNSConfig> getManagedDomains() {
    return managedDomains != null ? build(managedDomains) : null;
  }
  public List<ManageDNSConfig> buildManagedDomains() {
    return managedDomains != null ? build(managedDomains) : null;
  }
  public ManageDNSConfig buildManagedDomain(Integer index) {
    return this.managedDomains.get(index).build();
  }
  public ManageDNSConfig buildFirstManagedDomain() {
    return this.managedDomains.get(0).build();
  }
  public ManageDNSConfig buildLastManagedDomain() {
    return this.managedDomains.get(managedDomains.size() - 1).build();
  }
  public ManageDNSConfig buildMatchingManagedDomain(Predicate<ManageDNSConfigBuilder> predicate) {
    for (ManageDNSConfigBuilder item: managedDomains) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingManagedDomain(Predicate<ManageDNSConfigBuilder> predicate) {
    for (ManageDNSConfigBuilder item: managedDomains) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withManagedDomains(List<ManageDNSConfig> managedDomains) {
    if (this.managedDomains != null) { _visitables.get("managedDomains").removeAll(this.managedDomains);}
    if (managedDomains != null) {this.managedDomains = new ArrayList(); for (ManageDNSConfig item : managedDomains){this.addToManagedDomains(item);}} else { this.managedDomains = null;} return (A) this;
  }
  public A withManagedDomains(io.fabric8.openshift.api.model.hive.v1.ManageDNSConfig... managedDomains) {
    if (this.managedDomains != null) {this.managedDomains.clear();}
    if (managedDomains != null) {for (ManageDNSConfig item :managedDomains){ this.addToManagedDomains(item);}} return (A) this;
  }
  public Boolean hasManagedDomains() {
    return managedDomains != null && !managedDomains.isEmpty();
  }
  public HiveConfigSpecFluent.ManagedDomainsNested<A> addNewManagedDomain() {
    return new HiveConfigSpecFluentImpl.ManagedDomainsNestedImpl();
  }
  public HiveConfigSpecFluent.ManagedDomainsNested<A> addNewManagedDomainLike(ManageDNSConfig item) {
    return new HiveConfigSpecFluentImpl.ManagedDomainsNestedImpl(-1, item);
  }
  public HiveConfigSpecFluent.ManagedDomainsNested<A> setNewManagedDomainLike(Integer index,ManageDNSConfig item) {
    return new HiveConfigSpecFluentImpl.ManagedDomainsNestedImpl(index, item);
  }
  public HiveConfigSpecFluent.ManagedDomainsNested<A> editManagedDomain(Integer index) {
    if (managedDomains.size() <= index) throw new RuntimeException("Can't edit managedDomains. Index exceeds size.");
    return setNewManagedDomainLike(index, buildManagedDomain(index));
  }
  public HiveConfigSpecFluent.ManagedDomainsNested<A> editFirstManagedDomain() {
    if (managedDomains.size() == 0) throw new RuntimeException("Can't edit first managedDomains. The list is empty.");
    return setNewManagedDomainLike(0, buildManagedDomain(0));
  }
  public HiveConfigSpecFluent.ManagedDomainsNested<A> editLastManagedDomain() {
    int index = managedDomains.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last managedDomains. The list is empty.");
    return setNewManagedDomainLike(index, buildManagedDomain(index));
  }
  public HiveConfigSpecFluent.ManagedDomainsNested<A> editMatchingManagedDomain(Predicate<ManageDNSConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<managedDomains.size();i++) { 
    if (predicate.test(managedDomains.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching managedDomains. No match found.");
    return setNewManagedDomainLike(index, buildManagedDomain(index));
  }
  
  /**
   * This method has been deprecated, please use method buildReleaseImageVerificationConfigMapRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ReleaseImageVerificationConfigMapReference getReleaseImageVerificationConfigMapRef() {
    return this.releaseImageVerificationConfigMapRef!=null ?this.releaseImageVerificationConfigMapRef.build():null;
  }
  public ReleaseImageVerificationConfigMapReference buildReleaseImageVerificationConfigMapRef() {
    return this.releaseImageVerificationConfigMapRef!=null ?this.releaseImageVerificationConfigMapRef.build():null;
  }
  public A withReleaseImageVerificationConfigMapRef(ReleaseImageVerificationConfigMapReference releaseImageVerificationConfigMapRef) {
    _visitables.get("releaseImageVerificationConfigMapRef").remove(this.releaseImageVerificationConfigMapRef);
    if (releaseImageVerificationConfigMapRef!=null){ this.releaseImageVerificationConfigMapRef= new ReleaseImageVerificationConfigMapReferenceBuilder(releaseImageVerificationConfigMapRef); _visitables.get("releaseImageVerificationConfigMapRef").add(this.releaseImageVerificationConfigMapRef);} else { this.releaseImageVerificationConfigMapRef = null; _visitables.get("releaseImageVerificationConfigMapRef").remove(this.releaseImageVerificationConfigMapRef); } return (A) this;
  }
  public Boolean hasReleaseImageVerificationConfigMapRef() {
    return this.releaseImageVerificationConfigMapRef != null;
  }
  public A withNewReleaseImageVerificationConfigMapRef(String name,String namespace) {
    return (A)withReleaseImageVerificationConfigMapRef(new ReleaseImageVerificationConfigMapReference(name, namespace));
  }
  public HiveConfigSpecFluent.ReleaseImageVerificationConfigMapRefNested<A> withNewReleaseImageVerificationConfigMapRef() {
    return new HiveConfigSpecFluentImpl.ReleaseImageVerificationConfigMapRefNestedImpl();
  }
  public HiveConfigSpecFluent.ReleaseImageVerificationConfigMapRefNested<A> withNewReleaseImageVerificationConfigMapRefLike(ReleaseImageVerificationConfigMapReference item) {
    return new HiveConfigSpecFluentImpl.ReleaseImageVerificationConfigMapRefNestedImpl(item);
  }
  public HiveConfigSpecFluent.ReleaseImageVerificationConfigMapRefNested<A> editReleaseImageVerificationConfigMapRef() {
    return withNewReleaseImageVerificationConfigMapRefLike(getReleaseImageVerificationConfigMapRef());
  }
  public HiveConfigSpecFluent.ReleaseImageVerificationConfigMapRefNested<A> editOrNewReleaseImageVerificationConfigMapRef() {
    return withNewReleaseImageVerificationConfigMapRefLike(getReleaseImageVerificationConfigMapRef() != null ? getReleaseImageVerificationConfigMapRef(): new ReleaseImageVerificationConfigMapReferenceBuilder().build());
  }
  public HiveConfigSpecFluent.ReleaseImageVerificationConfigMapRefNested<A> editOrNewReleaseImageVerificationConfigMapRefLike(ReleaseImageVerificationConfigMapReference item) {
    return withNewReleaseImageVerificationConfigMapRefLike(getReleaseImageVerificationConfigMapRef() != null ? getReleaseImageVerificationConfigMapRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceProviderCredentialsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceProviderCredentials getServiceProviderCredentialsConfig() {
    return this.serviceProviderCredentialsConfig!=null ?this.serviceProviderCredentialsConfig.build():null;
  }
  public ServiceProviderCredentials buildServiceProviderCredentialsConfig() {
    return this.serviceProviderCredentialsConfig!=null ?this.serviceProviderCredentialsConfig.build():null;
  }
  public A withServiceProviderCredentialsConfig(ServiceProviderCredentials serviceProviderCredentialsConfig) {
    _visitables.get("serviceProviderCredentialsConfig").remove(this.serviceProviderCredentialsConfig);
    if (serviceProviderCredentialsConfig!=null){ this.serviceProviderCredentialsConfig= new ServiceProviderCredentialsBuilder(serviceProviderCredentialsConfig); _visitables.get("serviceProviderCredentialsConfig").add(this.serviceProviderCredentialsConfig);} else { this.serviceProviderCredentialsConfig = null; _visitables.get("serviceProviderCredentialsConfig").remove(this.serviceProviderCredentialsConfig); } return (A) this;
  }
  public Boolean hasServiceProviderCredentialsConfig() {
    return this.serviceProviderCredentialsConfig != null;
  }
  public HiveConfigSpecFluent.ServiceProviderCredentialsConfigNested<A> withNewServiceProviderCredentialsConfig() {
    return new HiveConfigSpecFluentImpl.ServiceProviderCredentialsConfigNestedImpl();
  }
  public HiveConfigSpecFluent.ServiceProviderCredentialsConfigNested<A> withNewServiceProviderCredentialsConfigLike(ServiceProviderCredentials item) {
    return new HiveConfigSpecFluentImpl.ServiceProviderCredentialsConfigNestedImpl(item);
  }
  public HiveConfigSpecFluent.ServiceProviderCredentialsConfigNested<A> editServiceProviderCredentialsConfig() {
    return withNewServiceProviderCredentialsConfigLike(getServiceProviderCredentialsConfig());
  }
  public HiveConfigSpecFluent.ServiceProviderCredentialsConfigNested<A> editOrNewServiceProviderCredentialsConfig() {
    return withNewServiceProviderCredentialsConfigLike(getServiceProviderCredentialsConfig() != null ? getServiceProviderCredentialsConfig(): new ServiceProviderCredentialsBuilder().build());
  }
  public HiveConfigSpecFluent.ServiceProviderCredentialsConfigNested<A> editOrNewServiceProviderCredentialsConfigLike(ServiceProviderCredentials item) {
    return withNewServiceProviderCredentialsConfigLike(getServiceProviderCredentialsConfig() != null ? getServiceProviderCredentialsConfig(): item);
  }
  public String getSyncSetReapplyInterval() {
    return this.syncSetReapplyInterval;
  }
  public A withSyncSetReapplyInterval(String syncSetReapplyInterval) {
    this.syncSetReapplyInterval=syncSetReapplyInterval; return (A) this;
  }
  public Boolean hasSyncSetReapplyInterval() {
    return this.syncSetReapplyInterval != null;
  }
  public String getTargetNamespace() {
    return this.targetNamespace;
  }
  public A withTargetNamespace(String targetNamespace) {
    this.targetNamespace=targetNamespace; return (A) this;
  }
  public Boolean hasTargetNamespace() {
    return this.targetNamespace != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HiveConfigSpecFluentImpl that = (HiveConfigSpecFluentImpl) o;
    if (additionalCertificateAuthoritiesSecretRef != null ? !additionalCertificateAuthoritiesSecretRef.equals(that.additionalCertificateAuthoritiesSecretRef) :that.additionalCertificateAuthoritiesSecretRef != null) return false;
    if (argoCDConfig != null ? !argoCDConfig.equals(that.argoCDConfig) :that.argoCDConfig != null) return false;
    if (awsPrivateLink != null ? !awsPrivateLink.equals(that.awsPrivateLink) :that.awsPrivateLink != null) return false;
    if (backup != null ? !backup.equals(that.backup) :that.backup != null) return false;
    if (controllersConfig != null ? !controllersConfig.equals(that.controllersConfig) :that.controllersConfig != null) return false;
    if (deleteProtection != null ? !deleteProtection.equals(that.deleteProtection) :that.deleteProtection != null) return false;
    if (deprovisionsDisabled != null ? !deprovisionsDisabled.equals(that.deprovisionsDisabled) :that.deprovisionsDisabled != null) return false;
    if (disabledControllers != null ? !disabledControllers.equals(that.disabledControllers) :that.disabledControllers != null) return false;
    if (exportMetrics != null ? !exportMetrics.equals(that.exportMetrics) :that.exportMetrics != null) return false;
    if (failedProvisionConfig != null ? !failedProvisionConfig.equals(that.failedProvisionConfig) :that.failedProvisionConfig != null) return false;
    if (featureGates != null ? !featureGates.equals(that.featureGates) :that.featureGates != null) return false;
    if (globalPullSecretRef != null ? !globalPullSecretRef.equals(that.globalPullSecretRef) :that.globalPullSecretRef != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (maintenanceMode != null ? !maintenanceMode.equals(that.maintenanceMode) :that.maintenanceMode != null) return false;
    if (managedDomains != null ? !managedDomains.equals(that.managedDomains) :that.managedDomains != null) return false;
    if (releaseImageVerificationConfigMapRef != null ? !releaseImageVerificationConfigMapRef.equals(that.releaseImageVerificationConfigMapRef) :that.releaseImageVerificationConfigMapRef != null) return false;
    if (serviceProviderCredentialsConfig != null ? !serviceProviderCredentialsConfig.equals(that.serviceProviderCredentialsConfig) :that.serviceProviderCredentialsConfig != null) return false;
    if (syncSetReapplyInterval != null ? !syncSetReapplyInterval.equals(that.syncSetReapplyInterval) :that.syncSetReapplyInterval != null) return false;
    if (targetNamespace != null ? !targetNamespace.equals(that.targetNamespace) :that.targetNamespace != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalCertificateAuthoritiesSecretRef,  argoCDConfig,  awsPrivateLink,  backup,  controllersConfig,  deleteProtection,  deprovisionsDisabled,  disabledControllers,  exportMetrics,  failedProvisionConfig,  featureGates,  globalPullSecretRef,  logLevel,  maintenanceMode,  managedDomains,  releaseImageVerificationConfigMapRef,  serviceProviderCredentialsConfig,  syncSetReapplyInterval,  targetNamespace,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalCertificateAuthoritiesSecretRef != null && !additionalCertificateAuthoritiesSecretRef.isEmpty()) { sb.append("additionalCertificateAuthoritiesSecretRef:"); sb.append(additionalCertificateAuthoritiesSecretRef + ","); }
    if (argoCDConfig != null) { sb.append("argoCDConfig:"); sb.append(argoCDConfig + ","); }
    if (awsPrivateLink != null) { sb.append("awsPrivateLink:"); sb.append(awsPrivateLink + ","); }
    if (backup != null) { sb.append("backup:"); sb.append(backup + ","); }
    if (controllersConfig != null) { sb.append("controllersConfig:"); sb.append(controllersConfig + ","); }
    if (deleteProtection != null) { sb.append("deleteProtection:"); sb.append(deleteProtection + ","); }
    if (deprovisionsDisabled != null) { sb.append("deprovisionsDisabled:"); sb.append(deprovisionsDisabled + ","); }
    if (disabledControllers != null && !disabledControllers.isEmpty()) { sb.append("disabledControllers:"); sb.append(disabledControllers + ","); }
    if (exportMetrics != null) { sb.append("exportMetrics:"); sb.append(exportMetrics + ","); }
    if (failedProvisionConfig != null) { sb.append("failedProvisionConfig:"); sb.append(failedProvisionConfig + ","); }
    if (featureGates != null) { sb.append("featureGates:"); sb.append(featureGates + ","); }
    if (globalPullSecretRef != null) { sb.append("globalPullSecretRef:"); sb.append(globalPullSecretRef + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (maintenanceMode != null) { sb.append("maintenanceMode:"); sb.append(maintenanceMode + ","); }
    if (managedDomains != null && !managedDomains.isEmpty()) { sb.append("managedDomains:"); sb.append(managedDomains + ","); }
    if (releaseImageVerificationConfigMapRef != null) { sb.append("releaseImageVerificationConfigMapRef:"); sb.append(releaseImageVerificationConfigMapRef + ","); }
    if (serviceProviderCredentialsConfig != null) { sb.append("serviceProviderCredentialsConfig:"); sb.append(serviceProviderCredentialsConfig + ","); }
    if (syncSetReapplyInterval != null) { sb.append("syncSetReapplyInterval:"); sb.append(syncSetReapplyInterval + ","); }
    if (targetNamespace != null) { sb.append("targetNamespace:"); sb.append(targetNamespace + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withDeprovisionsDisabled() {
    return withDeprovisionsDisabled(true);
  }
  public A withExportMetrics() {
    return withExportMetrics(true);
  }
  public A withMaintenanceMode() {
    return withMaintenanceMode(true);
  }
  class AdditionalCertificateAuthoritiesSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<N>> implements HiveConfigSpecFluent.AdditionalCertificateAuthoritiesSecretRefNested<N>,Nested<N>{
    AdditionalCertificateAuthoritiesSecretRefNestedImpl(Integer index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    AdditionalCertificateAuthoritiesSecretRefNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.setToAdditionalCertificateAuthoritiesSecretRef(index,builder.build());
    }
    public N endAdditionalCertificateAuthoritiesSecretRef() {
      return and();
    }
    
  }
  class ArgoCDConfigNestedImpl<N> extends ArgoCDConfigFluentImpl<HiveConfigSpecFluent.ArgoCDConfigNested<N>> implements HiveConfigSpecFluent.ArgoCDConfigNested<N>,Nested<N>{
    ArgoCDConfigNestedImpl(ArgoCDConfig item) {
      this.builder = new ArgoCDConfigBuilder(this, item);
    }
    ArgoCDConfigNestedImpl() {
      this.builder = new ArgoCDConfigBuilder(this);
    }
    ArgoCDConfigBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withArgoCDConfig(builder.build());
    }
    public N endArgoCDConfig() {
      return and();
    }
    
  }
  class AwsPrivateLinkNestedImpl<N> extends AWSPrivateLinkConfigFluentImpl<HiveConfigSpecFluent.AwsPrivateLinkNested<N>> implements HiveConfigSpecFluent.AwsPrivateLinkNested<N>,Nested<N>{
    AwsPrivateLinkNestedImpl(AWSPrivateLinkConfig item) {
      this.builder = new AWSPrivateLinkConfigBuilder(this, item);
    }
    AwsPrivateLinkNestedImpl() {
      this.builder = new AWSPrivateLinkConfigBuilder(this);
    }
    AWSPrivateLinkConfigBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withAwsPrivateLink(builder.build());
    }
    public N endAwsPrivateLink() {
      return and();
    }
    
  }
  class BackupNestedImpl<N> extends BackupConfigFluentImpl<HiveConfigSpecFluent.BackupNested<N>> implements HiveConfigSpecFluent.BackupNested<N>,Nested<N>{
    BackupNestedImpl(BackupConfig item) {
      this.builder = new BackupConfigBuilder(this, item);
    }
    BackupNestedImpl() {
      this.builder = new BackupConfigBuilder(this);
    }
    BackupConfigBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withBackup(builder.build());
    }
    public N endBackup() {
      return and();
    }
    
  }
  class ControllersConfigNestedImpl<N> extends ControllersConfigFluentImpl<HiveConfigSpecFluent.ControllersConfigNested<N>> implements HiveConfigSpecFluent.ControllersConfigNested<N>,Nested<N>{
    ControllersConfigNestedImpl(ControllersConfig item) {
      this.builder = new ControllersConfigBuilder(this, item);
    }
    ControllersConfigNestedImpl() {
      this.builder = new ControllersConfigBuilder(this);
    }
    ControllersConfigBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withControllersConfig(builder.build());
    }
    public N endControllersConfig() {
      return and();
    }
    
  }
  class FailedProvisionConfigNestedImpl<N> extends FailedProvisionConfigFluentImpl<HiveConfigSpecFluent.FailedProvisionConfigNested<N>> implements HiveConfigSpecFluent.FailedProvisionConfigNested<N>,Nested<N>{
    FailedProvisionConfigNestedImpl(FailedProvisionConfig item) {
      this.builder = new FailedProvisionConfigBuilder(this, item);
    }
    FailedProvisionConfigNestedImpl() {
      this.builder = new FailedProvisionConfigBuilder(this);
    }
    FailedProvisionConfigBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withFailedProvisionConfig(builder.build());
    }
    public N endFailedProvisionConfig() {
      return and();
    }
    
  }
  class FeatureGatesNestedImpl<N> extends FeatureGateSelectionFluentImpl<HiveConfigSpecFluent.FeatureGatesNested<N>> implements HiveConfigSpecFluent.FeatureGatesNested<N>,Nested<N>{
    FeatureGatesNestedImpl(FeatureGateSelection item) {
      this.builder = new FeatureGateSelectionBuilder(this, item);
    }
    FeatureGatesNestedImpl() {
      this.builder = new FeatureGateSelectionBuilder(this);
    }
    FeatureGateSelectionBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withFeatureGates(builder.build());
    }
    public N endFeatureGates() {
      return and();
    }
    
  }
  class GlobalPullSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<HiveConfigSpecFluent.GlobalPullSecretRefNested<N>> implements HiveConfigSpecFluent.GlobalPullSecretRefNested<N>,Nested<N>{
    GlobalPullSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    GlobalPullSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withGlobalPullSecretRef(builder.build());
    }
    public N endGlobalPullSecretRef() {
      return and();
    }
    
  }
  class ManagedDomainsNestedImpl<N> extends ManageDNSConfigFluentImpl<HiveConfigSpecFluent.ManagedDomainsNested<N>> implements HiveConfigSpecFluent.ManagedDomainsNested<N>,Nested<N>{
    ManagedDomainsNestedImpl(Integer index,ManageDNSConfig item) {
      this.index = index;
      this.builder = new ManageDNSConfigBuilder(this, item);
    }
    ManagedDomainsNestedImpl() {
      this.index = -1;
      this.builder = new ManageDNSConfigBuilder(this);
    }
    ManageDNSConfigBuilder builder;
    Integer index;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.setToManagedDomains(index,builder.build());
    }
    public N endManagedDomain() {
      return and();
    }
    
  }
  class ReleaseImageVerificationConfigMapRefNestedImpl<N> extends ReleaseImageVerificationConfigMapReferenceFluentImpl<HiveConfigSpecFluent.ReleaseImageVerificationConfigMapRefNested<N>> implements HiveConfigSpecFluent.ReleaseImageVerificationConfigMapRefNested<N>,Nested<N>{
    ReleaseImageVerificationConfigMapRefNestedImpl(ReleaseImageVerificationConfigMapReference item) {
      this.builder = new ReleaseImageVerificationConfigMapReferenceBuilder(this, item);
    }
    ReleaseImageVerificationConfigMapRefNestedImpl() {
      this.builder = new ReleaseImageVerificationConfigMapReferenceBuilder(this);
    }
    ReleaseImageVerificationConfigMapReferenceBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withReleaseImageVerificationConfigMapRef(builder.build());
    }
    public N endReleaseImageVerificationConfigMapRef() {
      return and();
    }
    
  }
  class ServiceProviderCredentialsConfigNestedImpl<N> extends ServiceProviderCredentialsFluentImpl<HiveConfigSpecFluent.ServiceProviderCredentialsConfigNested<N>> implements HiveConfigSpecFluent.ServiceProviderCredentialsConfigNested<N>,Nested<N>{
    ServiceProviderCredentialsConfigNestedImpl(ServiceProviderCredentials item) {
      this.builder = new ServiceProviderCredentialsBuilder(this, item);
    }
    ServiceProviderCredentialsConfigNestedImpl() {
      this.builder = new ServiceProviderCredentialsBuilder(this);
    }
    ServiceProviderCredentialsBuilder builder;
    public N and() {
      return (N) HiveConfigSpecFluentImpl.this.withServiceProviderCredentialsConfig(builder.build());
    }
    public N endServiceProviderCredentialsConfig() {
      return and();
    }
    
  }
  
}