package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HiveConfigStatusFluentImpl<A extends HiveConfigStatusFluent<A>> extends BaseFluent<A> implements HiveConfigStatusFluent<A>{
  public HiveConfigStatusFluentImpl() {
  }
  public HiveConfigStatusFluentImpl(HiveConfigStatus instance) {
    this.withAggregatorClientCAHash(instance.getAggregatorClientCAHash()); 
    this.withConditions(instance.getConditions()); 
    this.withConfigApplied(instance.getConfigApplied()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String aggregatorClientCAHash;
  private ArrayList<HiveConfigConditionBuilder> conditions = new ArrayList<HiveConfigConditionBuilder>();
  private Boolean configApplied;
  private Long observedGeneration;
  private Map<String,Object> additionalProperties;
  public String getAggregatorClientCAHash() {
    return this.aggregatorClientCAHash;
  }
  public A withAggregatorClientCAHash(String aggregatorClientCAHash) {
    this.aggregatorClientCAHash=aggregatorClientCAHash; return (A) this;
  }
  public Boolean hasAggregatorClientCAHash() {
    return this.aggregatorClientCAHash != null;
  }
  public A addToConditions(Integer index,HiveConfigCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<HiveConfigConditionBuilder>();}
    HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,HiveConfigCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<HiveConfigConditionBuilder>();}
    HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.hive.v1.HiveConfigCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<HiveConfigConditionBuilder>();}
    for (HiveConfigCondition item : items) {HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<HiveConfigCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<HiveConfigConditionBuilder>();}
    for (HiveConfigCondition item : items) {HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.hive.v1.HiveConfigCondition... items) {
    for (HiveConfigCondition item : items) {HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<HiveConfigCondition> items) {
    for (HiveConfigCondition item : items) {HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<HiveConfigConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<HiveConfigConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      HiveConfigConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HiveConfigCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<HiveConfigCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public HiveConfigCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public HiveConfigCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public HiveConfigCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public HiveConfigCondition buildMatchingCondition(Predicate<HiveConfigConditionBuilder> predicate) {
    for (HiveConfigConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<HiveConfigConditionBuilder> predicate) {
    for (HiveConfigConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<HiveConfigCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (HiveConfigCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.hive.v1.HiveConfigCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (HiveConfigCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public HiveConfigStatusFluent.ConditionsNested<A> addNewCondition() {
    return new HiveConfigStatusFluentImpl.ConditionsNestedImpl();
  }
  public HiveConfigStatusFluent.ConditionsNested<A> addNewConditionLike(HiveConfigCondition item) {
    return new HiveConfigStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public HiveConfigStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,HiveConfigCondition item) {
    return new HiveConfigStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public HiveConfigStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public HiveConfigStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public HiveConfigStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public HiveConfigStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<HiveConfigConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Boolean getConfigApplied() {
    return this.configApplied;
  }
  public A withConfigApplied(Boolean configApplied) {
    this.configApplied=configApplied; return (A) this;
  }
  public Boolean hasConfigApplied() {
    return this.configApplied != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HiveConfigStatusFluentImpl that = (HiveConfigStatusFluentImpl) o;
    if (aggregatorClientCAHash != null ? !aggregatorClientCAHash.equals(that.aggregatorClientCAHash) :that.aggregatorClientCAHash != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (configApplied != null ? !configApplied.equals(that.configApplied) :that.configApplied != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aggregatorClientCAHash,  conditions,  configApplied,  observedGeneration,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aggregatorClientCAHash != null) { sb.append("aggregatorClientCAHash:"); sb.append(aggregatorClientCAHash + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configApplied != null) { sb.append("configApplied:"); sb.append(configApplied + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withConfigApplied() {
    return withConfigApplied(true);
  }
  class ConditionsNestedImpl<N> extends HiveConfigConditionFluentImpl<HiveConfigStatusFluent.ConditionsNested<N>> implements HiveConfigStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,HiveConfigCondition item) {
      this.index = index;
      this.builder = new HiveConfigConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new HiveConfigConditionBuilder(this);
    }
    HiveConfigConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) HiveConfigStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}