package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenStackClusterDeprovisionBuilder extends OpenStackClusterDeprovisionFluentImpl<OpenStackClusterDeprovisionBuilder> implements VisitableBuilder<OpenStackClusterDeprovision,OpenStackClusterDeprovisionBuilder>{
  public OpenStackClusterDeprovisionBuilder() {
    this(false);
  }
  public OpenStackClusterDeprovisionBuilder(Boolean validationEnabled) {
    this(new OpenStackClusterDeprovision(), validationEnabled);
  }
  public OpenStackClusterDeprovisionBuilder(OpenStackClusterDeprovisionFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenStackClusterDeprovisionBuilder(OpenStackClusterDeprovisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenStackClusterDeprovision(), validationEnabled);
  }
  public OpenStackClusterDeprovisionBuilder(OpenStackClusterDeprovisionFluent<?> fluent,OpenStackClusterDeprovision instance) {
    this(fluent, instance, false);
  }
  public OpenStackClusterDeprovisionBuilder(OpenStackClusterDeprovisionFluent<?> fluent,OpenStackClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCertificatesSecretRef(instance.getCertificatesSecretRef()); 
    fluent.withCloud(instance.getCloud()); 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenStackClusterDeprovisionBuilder(OpenStackClusterDeprovision instance) {
    this(instance,false);
  }
  public OpenStackClusterDeprovisionBuilder(OpenStackClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCertificatesSecretRef(instance.getCertificatesSecretRef()); 
    this.withCloud(instance.getCloud()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OpenStackClusterDeprovisionFluent<?> fluent;
  Boolean validationEnabled;
  public OpenStackClusterDeprovision build() {
    OpenStackClusterDeprovision buildable = new OpenStackClusterDeprovision(fluent.getCertificatesSecretRef(),fluent.getCloud(),fluent.getCredentialsSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}