package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelectorSyncIdentityProviderListBuilder extends SelectorSyncIdentityProviderListFluentImpl<SelectorSyncIdentityProviderListBuilder> implements VisitableBuilder<SelectorSyncIdentityProviderList,SelectorSyncIdentityProviderListBuilder>{
  public SelectorSyncIdentityProviderListBuilder() {
    this(false);
  }
  public SelectorSyncIdentityProviderListBuilder(Boolean validationEnabled) {
    this(new SelectorSyncIdentityProviderList(), validationEnabled);
  }
  public SelectorSyncIdentityProviderListBuilder(SelectorSyncIdentityProviderListFluent<?> fluent) {
    this(fluent, false);
  }
  public SelectorSyncIdentityProviderListBuilder(SelectorSyncIdentityProviderListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelectorSyncIdentityProviderList(), validationEnabled);
  }
  public SelectorSyncIdentityProviderListBuilder(SelectorSyncIdentityProviderListFluent<?> fluent,SelectorSyncIdentityProviderList instance) {
    this(fluent, instance, false);
  }
  public SelectorSyncIdentityProviderListBuilder(SelectorSyncIdentityProviderListFluent<?> fluent,SelectorSyncIdentityProviderList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SelectorSyncIdentityProviderListBuilder(SelectorSyncIdentityProviderList instance) {
    this(instance,false);
  }
  public SelectorSyncIdentityProviderListBuilder(SelectorSyncIdentityProviderList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SelectorSyncIdentityProviderListFluent<?> fluent;
  Boolean validationEnabled;
  public SelectorSyncIdentityProviderList build() {
    SelectorSyncIdentityProviderList buildable = new SelectorSyncIdentityProviderList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}