package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelectorSyncSetListBuilder extends SelectorSyncSetListFluentImpl<SelectorSyncSetListBuilder> implements VisitableBuilder<SelectorSyncSetList,SelectorSyncSetListBuilder>{
  public SelectorSyncSetListBuilder() {
    this(false);
  }
  public SelectorSyncSetListBuilder(Boolean validationEnabled) {
    this(new SelectorSyncSetList(), validationEnabled);
  }
  public SelectorSyncSetListBuilder(SelectorSyncSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public SelectorSyncSetListBuilder(SelectorSyncSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelectorSyncSetList(), validationEnabled);
  }
  public SelectorSyncSetListBuilder(SelectorSyncSetListFluent<?> fluent,SelectorSyncSetList instance) {
    this(fluent, instance, false);
  }
  public SelectorSyncSetListBuilder(SelectorSyncSetListFluent<?> fluent,SelectorSyncSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SelectorSyncSetListBuilder(SelectorSyncSetList instance) {
    this(instance,false);
  }
  public SelectorSyncSetListBuilder(SelectorSyncSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SelectorSyncSetListFluent<?> fluent;
  Boolean validationEnabled;
  public SelectorSyncSetList build() {
    SelectorSyncSetList buildable = new SelectorSyncSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}