package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceProviderCredentialsBuilder extends ServiceProviderCredentialsFluentImpl<ServiceProviderCredentialsBuilder> implements VisitableBuilder<ServiceProviderCredentials,ServiceProviderCredentialsBuilder>{
  public ServiceProviderCredentialsBuilder() {
    this(false);
  }
  public ServiceProviderCredentialsBuilder(Boolean validationEnabled) {
    this(new ServiceProviderCredentials(), validationEnabled);
  }
  public ServiceProviderCredentialsBuilder(ServiceProviderCredentialsFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceProviderCredentialsBuilder(ServiceProviderCredentialsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceProviderCredentials(), validationEnabled);
  }
  public ServiceProviderCredentialsBuilder(ServiceProviderCredentialsFluent<?> fluent,ServiceProviderCredentials instance) {
    this(fluent, instance, false);
  }
  public ServiceProviderCredentialsBuilder(ServiceProviderCredentialsFluent<?> fluent,ServiceProviderCredentials instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAws(instance.getAws()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceProviderCredentialsBuilder(ServiceProviderCredentials instance) {
    this(instance,false);
  }
  public ServiceProviderCredentialsBuilder(ServiceProviderCredentials instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAws(instance.getAws()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceProviderCredentialsFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceProviderCredentials build() {
    ServiceProviderCredentials buildable = new ServiceProviderCredentials(fluent.getAws());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}