package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VeleroBackupConfigBuilder extends VeleroBackupConfigFluentImpl<VeleroBackupConfigBuilder> implements VisitableBuilder<VeleroBackupConfig,VeleroBackupConfigBuilder>{
  public VeleroBackupConfigBuilder() {
    this(false);
  }
  public VeleroBackupConfigBuilder(Boolean validationEnabled) {
    this(new VeleroBackupConfig(), validationEnabled);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VeleroBackupConfig(), validationEnabled);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent,VeleroBackupConfig instance) {
    this(fluent, instance, false);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent,VeleroBackupConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnabled(instance.getEnabled()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfig instance) {
    this(instance,false);
  }
  public VeleroBackupConfigBuilder(VeleroBackupConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnabled(instance.getEnabled()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VeleroBackupConfigFluent<?> fluent;
  Boolean validationEnabled;
  public VeleroBackupConfig build() {
    VeleroBackupConfig buildable = new VeleroBackupConfig(fluent.getEnabled(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}