package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withPrivateLink(instance.getPrivateLink());
      fluent.withRegion(instance.getRegion());
      fluent.withUserTags(instance.getUserTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withPrivateLink(instance.getPrivateLink());
      this.withRegion(instance.getRegion());
      this.withUserTags(instance.getUserTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getCredentialsAssumeRole(),fluent.getCredentialsSecretRef(),fluent.getPrivateLink(),fluent.getRegion(),fluent.getUserTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}