package io.fabric8.openshift.api.model.hive.aws.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    if (instance != null) {
      this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withPrivateLink(instance.getPrivateLink());
      this.withRegion(instance.getRegion());
      this.withUserTags(instance.getUserTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private AssumeRoleBuilder credentialsAssumeRole;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private PrivateLinkAccessBuilder privateLink;
  private String region;
  private Map<String,String> userTags;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCredentialsAssumeRole instead.
   * @return The buildable object.
   */
  @Deprecated
  public AssumeRole getCredentialsAssumeRole() {
    return this.credentialsAssumeRole!=null ?this.credentialsAssumeRole.build():null;
  }
  public AssumeRole buildCredentialsAssumeRole() {
    return this.credentialsAssumeRole!=null ?this.credentialsAssumeRole.build():null;
  }
  public A withCredentialsAssumeRole(AssumeRole credentialsAssumeRole) {
    _visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole);
    if (credentialsAssumeRole!=null){ this.credentialsAssumeRole= new AssumeRoleBuilder(credentialsAssumeRole); _visitables.get("credentialsAssumeRole").add(this.credentialsAssumeRole);} else { this.credentialsAssumeRole = null; _visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole); } return (A) this;
  }
  public Boolean hasCredentialsAssumeRole() {
    return this.credentialsAssumeRole != null;
  }
  public A withNewCredentialsAssumeRole(String externalID,String roleARN) {
    return (A)withCredentialsAssumeRole(new AssumeRole(externalID, roleARN));
  }
  public PlatformFluentImpl.CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRole() {
    return new PlatformFluentImpl.CredentialsAssumeRoleNestedImpl();
  }
  public PlatformFluentImpl.CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRoleLike(AssumeRole item) {
    return new PlatformFluentImpl.CredentialsAssumeRoleNestedImpl(item);
  }
  public PlatformFluentImpl.CredentialsAssumeRoleNested<A> editCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole());
  }
  public PlatformFluentImpl.CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole() != null ? getCredentialsAssumeRole(): new AssumeRoleBuilder().build());
  }
  public PlatformFluentImpl.CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRoleLike(AssumeRole item) {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole() != null ? getCredentialsAssumeRole(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCredentialsSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  public Boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new PlatformFluentImpl.CredentialsSecretRefNestedImpl();
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new PlatformFluentImpl.CredentialsSecretRefNestedImpl(item);
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef());
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPrivateLink instead.
   * @return The buildable object.
   */
  @Deprecated
  public PrivateLinkAccess getPrivateLink() {
    return this.privateLink!=null ?this.privateLink.build():null;
  }
  public PrivateLinkAccess buildPrivateLink() {
    return this.privateLink!=null ?this.privateLink.build():null;
  }
  public A withPrivateLink(PrivateLinkAccess privateLink) {
    _visitables.get("privateLink").remove(this.privateLink);
    if (privateLink!=null){ this.privateLink= new PrivateLinkAccessBuilder(privateLink); _visitables.get("privateLink").add(this.privateLink);} else { this.privateLink = null; _visitables.get("privateLink").remove(this.privateLink); } return (A) this;
  }
  public Boolean hasPrivateLink() {
    return this.privateLink != null;
  }
  public A withNewPrivateLink(Boolean enabled) {
    return (A)withPrivateLink(new PrivateLinkAccess(enabled));
  }
  public PlatformFluentImpl.PrivateLinkNested<A> withNewPrivateLink() {
    return new PlatformFluentImpl.PrivateLinkNestedImpl();
  }
  public PlatformFluentImpl.PrivateLinkNested<A> withNewPrivateLinkLike(PrivateLinkAccess item) {
    return new PlatformFluentImpl.PrivateLinkNestedImpl(item);
  }
  public PlatformFluentImpl.PrivateLinkNested<A> editPrivateLink() {
    return withNewPrivateLinkLike(getPrivateLink());
  }
  public PlatformFluentImpl.PrivateLinkNested<A> editOrNewPrivateLink() {
    return withNewPrivateLinkLike(getPrivateLink() != null ? getPrivateLink(): new PrivateLinkAccessBuilder().build());
  }
  public PlatformFluentImpl.PrivateLinkNested<A> editOrNewPrivateLinkLike(PrivateLinkAccess item) {
    return withNewPrivateLinkLike(getPrivateLink() != null ? getPrivateLink(): item);
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public A addToUserTags(String key,String value) {
    if(this.userTags == null && key != null && value != null) { this.userTags = new LinkedHashMap(); }
    if(key != null && value != null) {this.userTags.put(key, value);} return (A)this;
  }
  public A addToUserTags(Map<String,String> map) {
    if(this.userTags == null && map != null) { this.userTags = new LinkedHashMap(); }
    if(map != null) { this.userTags.putAll(map);} return (A)this;
  }
  public A removeFromUserTags(String key) {
    if(this.userTags == null) { return (A) this; }
    if(key != null && this.userTags != null) {this.userTags.remove(key);} return (A)this;
  }
  public A removeFromUserTags(Map<String,String> map) {
    if(this.userTags == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.userTags != null){this.userTags.remove(key);}}} return (A)this;
  }
  public Map<String,String> getUserTags() {
    return this.userTags;
  }
  public <K,V>A withUserTags(Map<String,String> userTags) {
    if (userTags == null) { this.userTags =  null;} else {this.userTags = new LinkedHashMap(userTags);} return (A) this;
  }
  public Boolean hasUserTags() {
    return this.userTags != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (!java.util.Objects.equals(credentialsAssumeRole, that.credentialsAssumeRole)) return false;

    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;

    if (!java.util.Objects.equals(privateLink, that.privateLink)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(userTags, that.userTags)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(credentialsAssumeRole,  credentialsSecretRef,  privateLink,  region,  userTags,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentialsAssumeRole != null) { sb.append("credentialsAssumeRole:"); sb.append(credentialsAssumeRole + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (privateLink != null) { sb.append("privateLink:"); sb.append(privateLink + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (userTags != null && !userTags.isEmpty()) { sb.append("userTags:"); sb.append(userTags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CredentialsAssumeRoleNestedImpl<N> extends AssumeRoleFluentImpl<PlatformFluentImpl.CredentialsAssumeRoleNested<N>> implements PlatformFluentImpl.CredentialsAssumeRoleNested<N>,Nested<N>{
    CredentialsAssumeRoleNestedImpl(AssumeRole item) {
      this.builder = new AssumeRoleBuilder(this, item);
    }
    CredentialsAssumeRoleNestedImpl() {
      this.builder = new AssumeRoleBuilder(this);
    }
    AssumeRoleBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withCredentialsAssumeRole(builder.build());
    }
    public N endCredentialsAssumeRole() {
      return and();
    }
    
  }
  class CredentialsSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<PlatformFluentImpl.CredentialsSecretRefNested<N>> implements PlatformFluentImpl.CredentialsSecretRefNested<N>,Nested<N>{
    CredentialsSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    CredentialsSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withCredentialsSecretRef(builder.build());
    }
    public N endCredentialsSecretRef() {
      return and();
    }
    
  }
  class PrivateLinkNestedImpl<N> extends PrivateLinkAccessFluentImpl<PlatformFluentImpl.PrivateLinkNested<N>> implements PlatformFluentImpl.PrivateLinkNested<N>,Nested<N>{
    PrivateLinkNestedImpl(PrivateLinkAccess item) {
      this.builder = new PrivateLinkAccessBuilder(this, item);
    }
    PrivateLinkNestedImpl() {
      this.builder = new PrivateLinkAccessBuilder(this);
    }
    PrivateLinkAccessBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withPrivateLink(builder.build());
    }
    public N endPrivateLink() {
      return and();
    }
    
  }
  
}