package io.fabric8.openshift.api.model.hive.aws.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PrivateLinkAccessStatusFluentImpl<A extends PrivateLinkAccessStatusFluent<A>> extends BaseFluent<A> implements PrivateLinkAccessStatusFluent<A>{
  public PrivateLinkAccessStatusFluentImpl() {
  }
  public PrivateLinkAccessStatusFluentImpl(PrivateLinkAccessStatus instance) {
    if (instance != null) {
      this.withHostedZoneID(instance.getHostedZoneID());
      this.withVpcEndpointID(instance.getVpcEndpointID());
      this.withVpcEndpointService(instance.getVpcEndpointService());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String hostedZoneID;
  private String vpcEndpointID;
  private VPCEndpointServiceBuilder vpcEndpointService;
  private Map<String,Object> additionalProperties;
  public String getHostedZoneID() {
    return this.hostedZoneID;
  }
  public A withHostedZoneID(String hostedZoneID) {
    this.hostedZoneID=hostedZoneID; return (A) this;
  }
  public Boolean hasHostedZoneID() {
    return this.hostedZoneID != null;
  }
  public String getVpcEndpointID() {
    return this.vpcEndpointID;
  }
  public A withVpcEndpointID(String vpcEndpointID) {
    this.vpcEndpointID=vpcEndpointID; return (A) this;
  }
  public Boolean hasVpcEndpointID() {
    return this.vpcEndpointID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVpcEndpointService instead.
   * @return The buildable object.
   */
  @Deprecated
  public VPCEndpointService getVpcEndpointService() {
    return this.vpcEndpointService!=null ?this.vpcEndpointService.build():null;
  }
  public VPCEndpointService buildVpcEndpointService() {
    return this.vpcEndpointService!=null ?this.vpcEndpointService.build():null;
  }
  public A withVpcEndpointService(VPCEndpointService vpcEndpointService) {
    _visitables.get("vpcEndpointService").remove(this.vpcEndpointService);
    if (vpcEndpointService!=null){ this.vpcEndpointService= new VPCEndpointServiceBuilder(vpcEndpointService); _visitables.get("vpcEndpointService").add(this.vpcEndpointService);} else { this.vpcEndpointService = null; _visitables.get("vpcEndpointService").remove(this.vpcEndpointService); } return (A) this;
  }
  public Boolean hasVpcEndpointService() {
    return this.vpcEndpointService != null;
  }
  public A withNewVpcEndpointService(String id,String name) {
    return (A)withVpcEndpointService(new VPCEndpointService(id, name));
  }
  public PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNested<A> withNewVpcEndpointService() {
    return new PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNestedImpl();
  }
  public PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNested<A> withNewVpcEndpointServiceLike(VPCEndpointService item) {
    return new PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNestedImpl(item);
  }
  public PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNested<A> editVpcEndpointService() {
    return withNewVpcEndpointServiceLike(getVpcEndpointService());
  }
  public PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNested<A> editOrNewVpcEndpointService() {
    return withNewVpcEndpointServiceLike(getVpcEndpointService() != null ? getVpcEndpointService(): new VPCEndpointServiceBuilder().build());
  }
  public PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNested<A> editOrNewVpcEndpointServiceLike(VPCEndpointService item) {
    return withNewVpcEndpointServiceLike(getVpcEndpointService() != null ? getVpcEndpointService(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrivateLinkAccessStatusFluentImpl that = (PrivateLinkAccessStatusFluentImpl) o;
    if (!java.util.Objects.equals(hostedZoneID, that.hostedZoneID)) return false;

    if (!java.util.Objects.equals(vpcEndpointID, that.vpcEndpointID)) return false;

    if (!java.util.Objects.equals(vpcEndpointService, that.vpcEndpointService)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hostedZoneID,  vpcEndpointID,  vpcEndpointService,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostedZoneID != null) { sb.append("hostedZoneID:"); sb.append(hostedZoneID + ","); }
    if (vpcEndpointID != null) { sb.append("vpcEndpointID:"); sb.append(vpcEndpointID + ","); }
    if (vpcEndpointService != null) { sb.append("vpcEndpointService:"); sb.append(vpcEndpointService + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class VpcEndpointServiceNestedImpl<N> extends VPCEndpointServiceFluentImpl<PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNested<N>> implements PrivateLinkAccessStatusFluentImpl.VpcEndpointServiceNested<N>,Nested<N>{
    VpcEndpointServiceNestedImpl(VPCEndpointService item) {
      this.builder = new VPCEndpointServiceBuilder(this, item);
    }
    VpcEndpointServiceNestedImpl() {
      this.builder = new VPCEndpointServiceBuilder(this);
    }
    VPCEndpointServiceBuilder builder;
    public N and() {
      return (N) PrivateLinkAccessStatusFluentImpl.this.withVpcEndpointService(builder.build());
    }
    public N endVpcEndpointService() {
      return and();
    }
    
  }
  
}