package io.fabric8.openshift.api.model.hive.azure.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    if (instance != null) {
      this.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName());
      this.withCloudName(instance.getCloudName());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withRegion(instance.getRegion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String baseDomainResourceGroupName;
  private String cloudName;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private String region;
  private Map<String,Object> additionalProperties;
  public String getBaseDomainResourceGroupName() {
    return this.baseDomainResourceGroupName;
  }
  public A withBaseDomainResourceGroupName(String baseDomainResourceGroupName) {
    this.baseDomainResourceGroupName=baseDomainResourceGroupName; return (A) this;
  }
  public Boolean hasBaseDomainResourceGroupName() {
    return this.baseDomainResourceGroupName != null;
  }
  public String getCloudName() {
    return this.cloudName;
  }
  public A withCloudName(String cloudName) {
    this.cloudName=cloudName; return (A) this;
  }
  public Boolean hasCloudName() {
    return this.cloudName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCredentialsSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  public Boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new PlatformFluentImpl.CredentialsSecretRefNestedImpl();
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new PlatformFluentImpl.CredentialsSecretRefNestedImpl(item);
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef());
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): item);
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (!java.util.Objects.equals(baseDomainResourceGroupName, that.baseDomainResourceGroupName)) return false;

    if (!java.util.Objects.equals(cloudName, that.cloudName)) return false;

    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseDomainResourceGroupName,  cloudName,  credentialsSecretRef,  region,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseDomainResourceGroupName != null) { sb.append("baseDomainResourceGroupName:"); sb.append(baseDomainResourceGroupName + ","); }
    if (cloudName != null) { sb.append("cloudName:"); sb.append(cloudName + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CredentialsSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<PlatformFluentImpl.CredentialsSecretRefNested<N>> implements PlatformFluentImpl.CredentialsSecretRefNested<N>,Nested<N>{
    CredentialsSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    CredentialsSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withCredentialsSecretRef(builder.build());
    }
    public N endCredentialsSecretRef() {
      return and();
    }
    
  }
  
}