package io.fabric8.openshift.api.model.hive.openstack.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>> extends BaseFluent<A> implements MachinePoolFluent<A>{
  public MachinePoolFluentImpl() {
  }
  public MachinePoolFluentImpl(MachinePool instance) {
    if (instance != null) {
      this.withFlavor(instance.getFlavor());
      this.withRootVolume(instance.getRootVolume());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String flavor;
  private RootVolumeBuilder rootVolume;
  private Map<String,Object> additionalProperties;
  public String getFlavor() {
    return this.flavor;
  }
  public A withFlavor(String flavor) {
    this.flavor=flavor; return (A) this;
  }
  public Boolean hasFlavor() {
    return this.flavor != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRootVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public RootVolume getRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  public RootVolume buildRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  public A withRootVolume(RootVolume rootVolume) {
    _visitables.get("rootVolume").remove(this.rootVolume);
    if (rootVolume!=null){ this.rootVolume= new RootVolumeBuilder(rootVolume); _visitables.get("rootVolume").add(this.rootVolume);} else { this.rootVolume = null; _visitables.get("rootVolume").remove(this.rootVolume); } return (A) this;
  }
  public Boolean hasRootVolume() {
    return this.rootVolume != null;
  }
  public A withNewRootVolume(Integer size,String type) {
    return (A)withRootVolume(new RootVolume(size, type));
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> withNewRootVolume() {
    return new MachinePoolFluentImpl.RootVolumeNestedImpl();
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
    return new MachinePoolFluentImpl.RootVolumeNestedImpl(item);
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> editRootVolume() {
    return withNewRootVolumeLike(getRootVolume());
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> editOrNewRootVolume() {
    return withNewRootVolumeLike(getRootVolume() != null ? getRootVolume(): new RootVolumeBuilder().build());
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
    return withNewRootVolumeLike(getRootVolume() != null ? getRootVolume(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluentImpl that = (MachinePoolFluentImpl) o;
    if (!java.util.Objects.equals(flavor, that.flavor)) return false;

    if (!java.util.Objects.equals(rootVolume, that.rootVolume)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(flavor,  rootVolume,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (flavor != null) { sb.append("flavor:"); sb.append(flavor + ","); }
    if (rootVolume != null) { sb.append("rootVolume:"); sb.append(rootVolume + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RootVolumeNestedImpl<N> extends RootVolumeFluentImpl<MachinePoolFluentImpl.RootVolumeNested<N>> implements MachinePoolFluentImpl.RootVolumeNested<N>,Nested<N>{
    RootVolumeNestedImpl(RootVolume item) {
      this.builder = new RootVolumeBuilder(this, item);
    }
    RootVolumeNestedImpl() {
      this.builder = new RootVolumeBuilder(this);
    }
    RootVolumeBuilder builder;
    public N and() {
      return (N) MachinePoolFluentImpl.this.withRootVolume(builder.build());
    }
    public N endRootVolume() {
      return and();
    }
    
  }
  
}