package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRole;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleBuilder;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AWSClusterDeprovisionFluentImpl<A extends AWSClusterDeprovisionFluent<A>> extends BaseFluent<A> implements AWSClusterDeprovisionFluent<A>{
  public AWSClusterDeprovisionFluentImpl() {
  }
  public AWSClusterDeprovisionFluentImpl(AWSClusterDeprovision instance) {
    if (instance != null) {
      this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withRegion(instance.getRegion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private AssumeRoleBuilder credentialsAssumeRole;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private String region;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCredentialsAssumeRole instead.
   * @return The buildable object.
   */
  @Deprecated
  public AssumeRole getCredentialsAssumeRole() {
    return this.credentialsAssumeRole!=null ?this.credentialsAssumeRole.build():null;
  }
  public AssumeRole buildCredentialsAssumeRole() {
    return this.credentialsAssumeRole!=null ?this.credentialsAssumeRole.build():null;
  }
  public A withCredentialsAssumeRole(AssumeRole credentialsAssumeRole) {
    _visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole);
    if (credentialsAssumeRole!=null){ this.credentialsAssumeRole= new AssumeRoleBuilder(credentialsAssumeRole); _visitables.get("credentialsAssumeRole").add(this.credentialsAssumeRole);} else { this.credentialsAssumeRole = null; _visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole); } return (A) this;
  }
  public Boolean hasCredentialsAssumeRole() {
    return this.credentialsAssumeRole != null;
  }
  public A withNewCredentialsAssumeRole(String externalID,String roleARN) {
    return (A)withCredentialsAssumeRole(new AssumeRole(externalID, roleARN));
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRole() {
    return new AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNestedImpl();
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRoleLike(AssumeRole item) {
    return new AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNestedImpl(item);
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNested<A> editCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole());
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole() != null ? getCredentialsAssumeRole(): new AssumeRoleBuilder().build());
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRoleLike(AssumeRole item) {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole() != null ? getCredentialsAssumeRole(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCredentialsSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  public Boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNestedImpl();
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNestedImpl(item);
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef());
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): item);
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSClusterDeprovisionFluentImpl that = (AWSClusterDeprovisionFluentImpl) o;
    if (!java.util.Objects.equals(credentialsAssumeRole, that.credentialsAssumeRole)) return false;

    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(credentialsAssumeRole,  credentialsSecretRef,  region,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentialsAssumeRole != null) { sb.append("credentialsAssumeRole:"); sb.append(credentialsAssumeRole + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CredentialsAssumeRoleNestedImpl<N> extends AssumeRoleFluentImpl<AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNested<N>> implements AWSClusterDeprovisionFluentImpl.CredentialsAssumeRoleNested<N>,Nested<N>{
    CredentialsAssumeRoleNestedImpl(AssumeRole item) {
      this.builder = new AssumeRoleBuilder(this, item);
    }
    CredentialsAssumeRoleNestedImpl() {
      this.builder = new AssumeRoleBuilder(this);
    }
    AssumeRoleBuilder builder;
    public N and() {
      return (N) AWSClusterDeprovisionFluentImpl.this.withCredentialsAssumeRole(builder.build());
    }
    public N endCredentialsAssumeRole() {
      return and();
    }
    
  }
  class CredentialsSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNested<N>> implements AWSClusterDeprovisionFluentImpl.CredentialsSecretRefNested<N>,Nested<N>{
    CredentialsSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    CredentialsSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) AWSClusterDeprovisionFluentImpl.this.withCredentialsSecretRef(builder.build());
    }
    public N endCredentialsSecretRef() {
      return and();
    }
    
  }
  
}