package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AWSPrivateLinkConfigFluentImpl<A extends AWSPrivateLinkConfigFluent<A>> extends BaseFluent<A> implements AWSPrivateLinkConfigFluent<A>{
  public AWSPrivateLinkConfigFluentImpl() {
  }
  public AWSPrivateLinkConfigFluentImpl(AWSPrivateLinkConfig instance) {
    if (instance != null) {
      this.withAssociatedVPCs(instance.getAssociatedVPCs());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withDnsRecordType(instance.getDnsRecordType());
      this.withEndpointVPCInventory(instance.getEndpointVPCInventory());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<AWSAssociatedVPCBuilder> associatedVPCs = new ArrayList<AWSAssociatedVPCBuilder>();
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private String dnsRecordType;
  private ArrayList<AWSPrivateLinkInventoryBuilder> endpointVPCInventory = new ArrayList<AWSPrivateLinkInventoryBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToAssociatedVPCs(int index,AWSAssociatedVPC item) {
    if (this.associatedVPCs == null) {this.associatedVPCs = new ArrayList<AWSAssociatedVPCBuilder>();}
    AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
    if (index < 0 || index >= associatedVPCs.size()) { _visitables.get("associatedVPCs").add(builder); associatedVPCs.add(builder); } else { _visitables.get("associatedVPCs").add(index, builder); associatedVPCs.add(index, builder);}
    return (A)this;
  }
  public A setToAssociatedVPCs(int index,AWSAssociatedVPC item) {
    if (this.associatedVPCs == null) {this.associatedVPCs = new ArrayList<AWSAssociatedVPCBuilder>();}
    AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
    if (index < 0 || index >= associatedVPCs.size()) { _visitables.get("associatedVPCs").add(builder); associatedVPCs.add(builder); } else { _visitables.get("associatedVPCs").set(index, builder); associatedVPCs.set(index, builder);}
    return (A)this;
  }
  public A addToAssociatedVPCs(io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPC... items) {
    if (this.associatedVPCs == null) {this.associatedVPCs = new ArrayList<AWSAssociatedVPCBuilder>();}
    for (AWSAssociatedVPC item : items) {AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);_visitables.get("associatedVPCs").add(builder);this.associatedVPCs.add(builder);} return (A)this;
  }
  public A addAllToAssociatedVPCs(Collection<AWSAssociatedVPC> items) {
    if (this.associatedVPCs == null) {this.associatedVPCs = new ArrayList<AWSAssociatedVPCBuilder>();}
    for (AWSAssociatedVPC item : items) {AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);_visitables.get("associatedVPCs").add(builder);this.associatedVPCs.add(builder);} return (A)this;
  }
  public A removeFromAssociatedVPCs(io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPC... items) {
    for (AWSAssociatedVPC item : items) {AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);_visitables.get("associatedVPCs").remove(builder);if (this.associatedVPCs != null) {this.associatedVPCs.remove(builder);}} return (A)this;
  }
  public A removeAllFromAssociatedVPCs(Collection<AWSAssociatedVPC> items) {
    for (AWSAssociatedVPC item : items) {AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);_visitables.get("associatedVPCs").remove(builder);if (this.associatedVPCs != null) {this.associatedVPCs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAssociatedVPCs(Predicate<AWSAssociatedVPCBuilder> predicate) {
    if (associatedVPCs == null) return (A) this;
    final Iterator<AWSAssociatedVPCBuilder> each = associatedVPCs.iterator();
    final List visitables = _visitables.get("associatedVPCs");
    while (each.hasNext()) {
      AWSAssociatedVPCBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAssociatedVPCs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AWSAssociatedVPC> getAssociatedVPCs() {
    return associatedVPCs != null ? build(associatedVPCs) : null;
  }
  public List<AWSAssociatedVPC> buildAssociatedVPCs() {
    return associatedVPCs != null ? build(associatedVPCs) : null;
  }
  public AWSAssociatedVPC buildAssociatedVPC(int index) {
    return this.associatedVPCs.get(index).build();
  }
  public AWSAssociatedVPC buildFirstAssociatedVPC() {
    return this.associatedVPCs.get(0).build();
  }
  public AWSAssociatedVPC buildLastAssociatedVPC() {
    return this.associatedVPCs.get(associatedVPCs.size() - 1).build();
  }
  public AWSAssociatedVPC buildMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
    for (AWSAssociatedVPCBuilder item: associatedVPCs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
    for (AWSAssociatedVPCBuilder item: associatedVPCs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAssociatedVPCs(List<AWSAssociatedVPC> associatedVPCs) {
    if (this.associatedVPCs != null) { _visitables.get("associatedVPCs").clear();}
    if (associatedVPCs != null) {this.associatedVPCs = new ArrayList(); for (AWSAssociatedVPC item : associatedVPCs){this.addToAssociatedVPCs(item);}} else { this.associatedVPCs = null;} return (A) this;
  }
  public A withAssociatedVPCs(io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPC... associatedVPCs) {
    if (this.associatedVPCs != null) {this.associatedVPCs.clear(); _visitables.remove("associatedVPCs"); }
    if (associatedVPCs != null) {for (AWSAssociatedVPC item :associatedVPCs){ this.addToAssociatedVPCs(item);}} return (A) this;
  }
  public Boolean hasAssociatedVPCs() {
    return associatedVPCs != null && !associatedVPCs.isEmpty();
  }
  public AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<A> addNewAssociatedVPC() {
    return new AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNestedImpl();
  }
  public AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<A> addNewAssociatedVPCLike(AWSAssociatedVPC item) {
    return new AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNestedImpl(-1, item);
  }
  public AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<A> setNewAssociatedVPCLike(int index,AWSAssociatedVPC item) {
    return new AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNestedImpl(index, item);
  }
  public AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<A> editAssociatedVPC(int index) {
    if (associatedVPCs.size() <= index) throw new RuntimeException("Can't edit associatedVPCs. Index exceeds size.");
    return setNewAssociatedVPCLike(index, buildAssociatedVPC(index));
  }
  public AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<A> editFirstAssociatedVPC() {
    if (associatedVPCs.size() == 0) throw new RuntimeException("Can't edit first associatedVPCs. The list is empty.");
    return setNewAssociatedVPCLike(0, buildAssociatedVPC(0));
  }
  public AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<A> editLastAssociatedVPC() {
    int index = associatedVPCs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last associatedVPCs. The list is empty.");
    return setNewAssociatedVPCLike(index, buildAssociatedVPC(index));
  }
  public AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<A> editMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
    int index = -1;
    for (int i=0;i<associatedVPCs.size();i++) { 
    if (predicate.test(associatedVPCs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching associatedVPCs. No match found.");
    return setNewAssociatedVPCLike(index, buildAssociatedVPC(index));
  }
  
  /**
   * This method has been deprecated, please use method buildCredentialsSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  public Boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  public AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNestedImpl();
  }
  public AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNestedImpl(item);
  }
  public AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef());
  }
  public AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): item);
  }
  public String getDnsRecordType() {
    return this.dnsRecordType;
  }
  public A withDnsRecordType(String dnsRecordType) {
    this.dnsRecordType=dnsRecordType; return (A) this;
  }
  public Boolean hasDnsRecordType() {
    return this.dnsRecordType != null;
  }
  public A addToEndpointVPCInventory(int index,AWSPrivateLinkInventory item) {
    if (this.endpointVPCInventory == null) {this.endpointVPCInventory = new ArrayList<AWSPrivateLinkInventoryBuilder>();}
    AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
    if (index < 0 || index >= endpointVPCInventory.size()) { _visitables.get("endpointVPCInventory").add(builder); endpointVPCInventory.add(builder); } else { _visitables.get("endpointVPCInventory").add(index, builder); endpointVPCInventory.add(index, builder);}
    return (A)this;
  }
  public A setToEndpointVPCInventory(int index,AWSPrivateLinkInventory item) {
    if (this.endpointVPCInventory == null) {this.endpointVPCInventory = new ArrayList<AWSPrivateLinkInventoryBuilder>();}
    AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
    if (index < 0 || index >= endpointVPCInventory.size()) { _visitables.get("endpointVPCInventory").add(builder); endpointVPCInventory.add(builder); } else { _visitables.get("endpointVPCInventory").set(index, builder); endpointVPCInventory.set(index, builder);}
    return (A)this;
  }
  public A addToEndpointVPCInventory(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory... items) {
    if (this.endpointVPCInventory == null) {this.endpointVPCInventory = new ArrayList<AWSPrivateLinkInventoryBuilder>();}
    for (AWSPrivateLinkInventory item : items) {AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);_visitables.get("endpointVPCInventory").add(builder);this.endpointVPCInventory.add(builder);} return (A)this;
  }
  public A addAllToEndpointVPCInventory(Collection<AWSPrivateLinkInventory> items) {
    if (this.endpointVPCInventory == null) {this.endpointVPCInventory = new ArrayList<AWSPrivateLinkInventoryBuilder>();}
    for (AWSPrivateLinkInventory item : items) {AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);_visitables.get("endpointVPCInventory").add(builder);this.endpointVPCInventory.add(builder);} return (A)this;
  }
  public A removeFromEndpointVPCInventory(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory... items) {
    for (AWSPrivateLinkInventory item : items) {AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);_visitables.get("endpointVPCInventory").remove(builder);if (this.endpointVPCInventory != null) {this.endpointVPCInventory.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpointVPCInventory(Collection<AWSPrivateLinkInventory> items) {
    for (AWSPrivateLinkInventory item : items) {AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);_visitables.get("endpointVPCInventory").remove(builder);if (this.endpointVPCInventory != null) {this.endpointVPCInventory.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
    if (endpointVPCInventory == null) return (A) this;
    final Iterator<AWSPrivateLinkInventoryBuilder> each = endpointVPCInventory.iterator();
    final List visitables = _visitables.get("endpointVPCInventory");
    while (each.hasNext()) {
      AWSPrivateLinkInventoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointVPCInventory instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AWSPrivateLinkInventory> getEndpointVPCInventory() {
    return endpointVPCInventory != null ? build(endpointVPCInventory) : null;
  }
  public List<AWSPrivateLinkInventory> buildEndpointVPCInventory() {
    return endpointVPCInventory != null ? build(endpointVPCInventory) : null;
  }
  public AWSPrivateLinkInventory buildEndpointVPCInventory(int index) {
    return this.endpointVPCInventory.get(index).build();
  }
  public AWSPrivateLinkInventory buildFirstEndpointVPCInventory() {
    return this.endpointVPCInventory.get(0).build();
  }
  public AWSPrivateLinkInventory buildLastEndpointVPCInventory() {
    return this.endpointVPCInventory.get(endpointVPCInventory.size() - 1).build();
  }
  public AWSPrivateLinkInventory buildMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
    for (AWSPrivateLinkInventoryBuilder item: endpointVPCInventory) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
    for (AWSPrivateLinkInventoryBuilder item: endpointVPCInventory) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEndpointVPCInventory(List<AWSPrivateLinkInventory> endpointVPCInventory) {
    if (this.endpointVPCInventory != null) { _visitables.get("endpointVPCInventory").clear();}
    if (endpointVPCInventory != null) {this.endpointVPCInventory = new ArrayList(); for (AWSPrivateLinkInventory item : endpointVPCInventory){this.addToEndpointVPCInventory(item);}} else { this.endpointVPCInventory = null;} return (A) this;
  }
  public A withEndpointVPCInventory(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory... endpointVPCInventory) {
    if (this.endpointVPCInventory != null) {this.endpointVPCInventory.clear(); _visitables.remove("endpointVPCInventory"); }
    if (endpointVPCInventory != null) {for (AWSPrivateLinkInventory item :endpointVPCInventory){ this.addToEndpointVPCInventory(item);}} return (A) this;
  }
  public Boolean hasEndpointVPCInventory() {
    return endpointVPCInventory != null && !endpointVPCInventory.isEmpty();
  }
  public AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<A> addNewEndpointVPCInventory() {
    return new AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNestedImpl();
  }
  public AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<A> addNewEndpointVPCInventoryLike(AWSPrivateLinkInventory item) {
    return new AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNestedImpl(-1, item);
  }
  public AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<A> setNewEndpointVPCInventoryLike(int index,AWSPrivateLinkInventory item) {
    return new AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNestedImpl(index, item);
  }
  public AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<A> editEndpointVPCInventory(int index) {
    if (endpointVPCInventory.size() <= index) throw new RuntimeException("Can't edit endpointVPCInventory. Index exceeds size.");
    return setNewEndpointVPCInventoryLike(index, buildEndpointVPCInventory(index));
  }
  public AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<A> editFirstEndpointVPCInventory() {
    if (endpointVPCInventory.size() == 0) throw new RuntimeException("Can't edit first endpointVPCInventory. The list is empty.");
    return setNewEndpointVPCInventoryLike(0, buildEndpointVPCInventory(0));
  }
  public AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<A> editLastEndpointVPCInventory() {
    int index = endpointVPCInventory.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpointVPCInventory. The list is empty.");
    return setNewEndpointVPCInventoryLike(index, buildEndpointVPCInventory(index));
  }
  public AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<A> editMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpointVPCInventory.size();i++) { 
    if (predicate.test(endpointVPCInventory.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpointVPCInventory. No match found.");
    return setNewEndpointVPCInventoryLike(index, buildEndpointVPCInventory(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPrivateLinkConfigFluentImpl that = (AWSPrivateLinkConfigFluentImpl) o;
    if (!java.util.Objects.equals(associatedVPCs, that.associatedVPCs)) return false;

    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;

    if (!java.util.Objects.equals(dnsRecordType, that.dnsRecordType)) return false;

    if (!java.util.Objects.equals(endpointVPCInventory, that.endpointVPCInventory)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(associatedVPCs,  credentialsSecretRef,  dnsRecordType,  endpointVPCInventory,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (associatedVPCs != null) { sb.append("associatedVPCs:"); sb.append(associatedVPCs + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (dnsRecordType != null) { sb.append("dnsRecordType:"); sb.append(dnsRecordType + ","); }
    if (endpointVPCInventory != null) { sb.append("endpointVPCInventory:"); sb.append(endpointVPCInventory + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AssociatedVPCsNestedImpl<N> extends AWSAssociatedVPCFluentImpl<AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<N>> implements AWSPrivateLinkConfigFluentImpl.AssociatedVPCsNested<N>,Nested<N>{
    AssociatedVPCsNestedImpl(int index,AWSAssociatedVPC item) {
      this.index = index;
      this.builder = new AWSAssociatedVPCBuilder(this, item);
    }
    AssociatedVPCsNestedImpl() {
      this.index = -1;
      this.builder = new AWSAssociatedVPCBuilder(this);
    }
    AWSAssociatedVPCBuilder builder;
    int index;
    public N and() {
      return (N) AWSPrivateLinkConfigFluentImpl.this.setToAssociatedVPCs(index,builder.build());
    }
    public N endAssociatedVPC() {
      return and();
    }
    
  }
  class CredentialsSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNested<N>> implements AWSPrivateLinkConfigFluentImpl.CredentialsSecretRefNested<N>,Nested<N>{
    CredentialsSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    CredentialsSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) AWSPrivateLinkConfigFluentImpl.this.withCredentialsSecretRef(builder.build());
    }
    public N endCredentialsSecretRef() {
      return and();
    }
    
  }
  class EndpointVPCInventoryNestedImpl<N> extends AWSPrivateLinkInventoryFluentImpl<AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<N>> implements AWSPrivateLinkConfigFluentImpl.EndpointVPCInventoryNested<N>,Nested<N>{
    EndpointVPCInventoryNestedImpl(int index,AWSPrivateLinkInventory item) {
      this.index = index;
      this.builder = new AWSPrivateLinkInventoryBuilder(this, item);
    }
    EndpointVPCInventoryNestedImpl() {
      this.index = -1;
      this.builder = new AWSPrivateLinkInventoryBuilder(this);
    }
    AWSPrivateLinkInventoryBuilder builder;
    int index;
    public N and() {
      return (N) AWSPrivateLinkConfigFluentImpl.this.setToEndpointVPCInventory(index,builder.build());
    }
    public N endEndpointVPCInventory() {
      return and();
    }
    
  }
  
}