package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ArgoCDConfigBuilder extends ArgoCDConfigFluentImpl<ArgoCDConfigBuilder> implements VisitableBuilder<ArgoCDConfig,ArgoCDConfigBuilder>{
  public ArgoCDConfigBuilder() {
    this(false);
  }
  public ArgoCDConfigBuilder(Boolean validationEnabled) {
    this(new ArgoCDConfig(), validationEnabled);
  }
  public ArgoCDConfigBuilder(ArgoCDConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ArgoCDConfigBuilder(ArgoCDConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ArgoCDConfig(), validationEnabled);
  }
  public ArgoCDConfigBuilder(ArgoCDConfigFluent<?> fluent,ArgoCDConfig instance) {
    this(fluent, instance, false);
  }
  public ArgoCDConfigBuilder(ArgoCDConfigFluent<?> fluent,ArgoCDConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEnabled(instance.getEnabled());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ArgoCDConfigBuilder(ArgoCDConfig instance) {
    this(instance,false);
  }
  public ArgoCDConfigBuilder(ArgoCDConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEnabled(instance.getEnabled());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ArgoCDConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ArgoCDConfig build() {
    ArgoCDConfig buildable = new ArgoCDConfig(fluent.getEnabled(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}