package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BackupConfigFluentImpl<A extends BackupConfigFluent<A>> extends BaseFluent<A> implements BackupConfigFluent<A>{
  public BackupConfigFluentImpl() {
  }
  public BackupConfigFluentImpl(BackupConfig instance) {
    if (instance != null) {
      this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
      this.withVelero(instance.getVelero());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Integer minBackupPeriodSeconds;
  private VeleroBackupConfigBuilder velero;
  private Map<String,Object> additionalProperties;
  public Integer getMinBackupPeriodSeconds() {
    return this.minBackupPeriodSeconds;
  }
  public A withMinBackupPeriodSeconds(Integer minBackupPeriodSeconds) {
    this.minBackupPeriodSeconds=minBackupPeriodSeconds; return (A) this;
  }
  public Boolean hasMinBackupPeriodSeconds() {
    return this.minBackupPeriodSeconds != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVelero instead.
   * @return The buildable object.
   */
  @Deprecated
  public VeleroBackupConfig getVelero() {
    return this.velero!=null ?this.velero.build():null;
  }
  public VeleroBackupConfig buildVelero() {
    return this.velero!=null ?this.velero.build():null;
  }
  public A withVelero(VeleroBackupConfig velero) {
    _visitables.get("velero").remove(this.velero);
    if (velero!=null){ this.velero= new VeleroBackupConfigBuilder(velero); _visitables.get("velero").add(this.velero);} else { this.velero = null; _visitables.get("velero").remove(this.velero); } return (A) this;
  }
  public Boolean hasVelero() {
    return this.velero != null;
  }
  public A withNewVelero(Boolean enabled,String namespace) {
    return (A)withVelero(new VeleroBackupConfig(enabled, namespace));
  }
  public BackupConfigFluentImpl.VeleroNested<A> withNewVelero() {
    return new BackupConfigFluentImpl.VeleroNestedImpl();
  }
  public BackupConfigFluentImpl.VeleroNested<A> withNewVeleroLike(VeleroBackupConfig item) {
    return new BackupConfigFluentImpl.VeleroNestedImpl(item);
  }
  public BackupConfigFluentImpl.VeleroNested<A> editVelero() {
    return withNewVeleroLike(getVelero());
  }
  public BackupConfigFluentImpl.VeleroNested<A> editOrNewVelero() {
    return withNewVeleroLike(getVelero() != null ? getVelero(): new VeleroBackupConfigBuilder().build());
  }
  public BackupConfigFluentImpl.VeleroNested<A> editOrNewVeleroLike(VeleroBackupConfig item) {
    return withNewVeleroLike(getVelero() != null ? getVelero(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackupConfigFluentImpl that = (BackupConfigFluentImpl) o;
    if (!java.util.Objects.equals(minBackupPeriodSeconds, that.minBackupPeriodSeconds)) return false;

    if (!java.util.Objects.equals(velero, that.velero)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minBackupPeriodSeconds,  velero,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minBackupPeriodSeconds != null) { sb.append("minBackupPeriodSeconds:"); sb.append(minBackupPeriodSeconds + ","); }
    if (velero != null) { sb.append("velero:"); sb.append(velero + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class VeleroNestedImpl<N> extends VeleroBackupConfigFluentImpl<BackupConfigFluentImpl.VeleroNested<N>> implements BackupConfigFluentImpl.VeleroNested<N>,Nested<N>{
    VeleroNestedImpl(VeleroBackupConfig item) {
      this.builder = new VeleroBackupConfigBuilder(this, item);
    }
    VeleroNestedImpl() {
      this.builder = new VeleroBackupConfigBuilder(this);
    }
    VeleroBackupConfigBuilder builder;
    public N and() {
      return (N) BackupConfigFluentImpl.this.withVelero(builder.build());
    }
    public N endVelero() {
      return and();
    }
    
  }
  
}