package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CheckpointStatusBuilder extends CheckpointStatusFluentImpl<CheckpointStatusBuilder> implements VisitableBuilder<CheckpointStatus,CheckpointStatusBuilder>{
  public CheckpointStatusBuilder() {
    this(false);
  }
  public CheckpointStatusBuilder(Boolean validationEnabled) {
    this(new CheckpointStatus(), validationEnabled);
  }
  public CheckpointStatusBuilder(CheckpointStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CheckpointStatusBuilder(CheckpointStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CheckpointStatus(), validationEnabled);
  }
  public CheckpointStatusBuilder(CheckpointStatusFluent<?> fluent,CheckpointStatus instance) {
    this(fluent, instance, false);
  }
  public CheckpointStatusBuilder(CheckpointStatusFluent<?> fluent,CheckpointStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CheckpointStatusBuilder(CheckpointStatus instance) {
    this(instance,false);
  }
  public CheckpointStatusBuilder(CheckpointStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CheckpointStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CheckpointStatus build() {
    CheckpointStatus buildable = new CheckpointStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}