package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeprovisionConditionBuilder extends ClusterDeprovisionConditionFluentImpl<ClusterDeprovisionConditionBuilder> implements VisitableBuilder<ClusterDeprovisionCondition,ClusterDeprovisionConditionBuilder>{
  public ClusterDeprovisionConditionBuilder() {
    this(false);
  }
  public ClusterDeprovisionConditionBuilder(Boolean validationEnabled) {
    this(new ClusterDeprovisionCondition(), validationEnabled);
  }
  public ClusterDeprovisionConditionBuilder(ClusterDeprovisionConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeprovisionConditionBuilder(ClusterDeprovisionConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeprovisionCondition(), validationEnabled);
  }
  public ClusterDeprovisionConditionBuilder(ClusterDeprovisionConditionFluent<?> fluent,ClusterDeprovisionCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterDeprovisionConditionBuilder(ClusterDeprovisionConditionFluent<?> fluent,ClusterDeprovisionCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeprovisionConditionBuilder(ClusterDeprovisionCondition instance) {
    this(instance,false);
  }
  public ClusterDeprovisionConditionBuilder(ClusterDeprovisionCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDeprovisionConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeprovisionCondition build() {
    ClusterDeprovisionCondition buildable = new ClusterDeprovisionCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}