package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterImageSetBuilder extends ClusterImageSetFluentImpl<ClusterImageSetBuilder> implements VisitableBuilder<ClusterImageSet,ClusterImageSetBuilder>{
  public ClusterImageSetBuilder() {
    this(false);
  }
  public ClusterImageSetBuilder(Boolean validationEnabled) {
    this(new ClusterImageSet(), validationEnabled);
  }
  public ClusterImageSetBuilder(ClusterImageSetFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterImageSetBuilder(ClusterImageSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterImageSet(), validationEnabled);
  }
  public ClusterImageSetBuilder(ClusterImageSetFluent<?> fluent,ClusterImageSet instance) {
    this(fluent, instance, false);
  }
  public ClusterImageSetBuilder(ClusterImageSetFluent<?> fluent,ClusterImageSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterImageSetBuilder(ClusterImageSet instance) {
    this(instance,false);
  }
  public ClusterImageSetBuilder(ClusterImageSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterImageSetFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterImageSet build() {
    ClusterImageSet buildable = new ClusterImageSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}