package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterImageSetFluent<A extends ClusterImageSetFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ClusterImageSetFluent.MetadataNested<A> withNewMetadata();
  public ClusterImageSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ClusterImageSetFluent.MetadataNested<A> editMetadata();
  public ClusterImageSetFluent.MetadataNested<A> editOrNewMetadata();
  public ClusterImageSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterImageSetSpec getSpec();
  public ClusterImageSetSpec buildSpec();
  public A withSpec(ClusterImageSetSpec spec);
  public Boolean hasSpec();
  public A withNewSpec(String releaseImage);
  public ClusterImageSetFluent.SpecNested<A> withNewSpec();
  public ClusterImageSetFluent.SpecNested<A> withNewSpecLike(ClusterImageSetSpec item);
  public ClusterImageSetFluent.SpecNested<A> editSpec();
  public ClusterImageSetFluent.SpecNested<A> editOrNewSpec();
  public ClusterImageSetFluent.SpecNested<A> editOrNewSpecLike(ClusterImageSetSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterImageSetStatus getStatus();
  public ClusterImageSetStatus buildStatus();
  public A withStatus(ClusterImageSetStatus status);
  public Boolean hasStatus();
  public ClusterImageSetFluent.StatusNested<A> withNewStatus();
  public ClusterImageSetFluent.StatusNested<A> withNewStatusLike(ClusterImageSetStatus item);
  public ClusterImageSetFluent.StatusNested<A> editStatus();
  public ClusterImageSetFluent.StatusNested<A> editOrNewStatus();
  public ClusterImageSetFluent.StatusNested<A> editOrNewStatusLike(ClusterImageSetStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ClusterImageSetFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ClusterImageSetSpecFluent<ClusterImageSetFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ClusterImageSetStatusFluent<ClusterImageSetFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}