package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterImageSetReferenceBuilder extends ClusterImageSetReferenceFluentImpl<ClusterImageSetReferenceBuilder> implements VisitableBuilder<ClusterImageSetReference,ClusterImageSetReferenceBuilder>{
  public ClusterImageSetReferenceBuilder() {
    this(false);
  }
  public ClusterImageSetReferenceBuilder(Boolean validationEnabled) {
    this(new ClusterImageSetReference(), validationEnabled);
  }
  public ClusterImageSetReferenceBuilder(ClusterImageSetReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterImageSetReferenceBuilder(ClusterImageSetReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterImageSetReference(), validationEnabled);
  }
  public ClusterImageSetReferenceBuilder(ClusterImageSetReferenceFluent<?> fluent,ClusterImageSetReference instance) {
    this(fluent, instance, false);
  }
  public ClusterImageSetReferenceBuilder(ClusterImageSetReferenceFluent<?> fluent,ClusterImageSetReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterImageSetReferenceBuilder(ClusterImageSetReference instance) {
    this(instance,false);
  }
  public ClusterImageSetReferenceBuilder(ClusterImageSetReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterImageSetReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterImageSetReference build() {
    ClusterImageSetReference buildable = new ClusterImageSetReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}