package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterPoolListBuilder extends ClusterPoolListFluentImpl<ClusterPoolListBuilder> implements VisitableBuilder<ClusterPoolList,ClusterPoolListBuilder>{
  public ClusterPoolListBuilder() {
    this(false);
  }
  public ClusterPoolListBuilder(Boolean validationEnabled) {
    this(new ClusterPoolList(), validationEnabled);
  }
  public ClusterPoolListBuilder(ClusterPoolListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterPoolListBuilder(ClusterPoolListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterPoolList(), validationEnabled);
  }
  public ClusterPoolListBuilder(ClusterPoolListFluent<?> fluent,ClusterPoolList instance) {
    this(fluent, instance, false);
  }
  public ClusterPoolListBuilder(ClusterPoolListFluent<?> fluent,ClusterPoolList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterPoolListBuilder(ClusterPoolList instance) {
    this(instance,false);
  }
  public ClusterPoolListBuilder(ClusterPoolList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterPoolListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterPoolList build() {
    ClusterPoolList buildable = new ClusterPoolList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}