package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterPoolReferenceBuilder extends ClusterPoolReferenceFluentImpl<ClusterPoolReferenceBuilder> implements VisitableBuilder<ClusterPoolReference,ClusterPoolReferenceBuilder>{
  public ClusterPoolReferenceBuilder() {
    this(false);
  }
  public ClusterPoolReferenceBuilder(Boolean validationEnabled) {
    this(new ClusterPoolReference(), validationEnabled);
  }
  public ClusterPoolReferenceBuilder(ClusterPoolReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterPoolReferenceBuilder(ClusterPoolReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterPoolReference(), validationEnabled);
  }
  public ClusterPoolReferenceBuilder(ClusterPoolReferenceFluent<?> fluent,ClusterPoolReference instance) {
    this(fluent, instance, false);
  }
  public ClusterPoolReferenceBuilder(ClusterPoolReferenceFluent<?> fluent,ClusterPoolReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClaimName(instance.getClaimName());
      fluent.withClaimedTimestamp(instance.getClaimedTimestamp());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPoolName(instance.getPoolName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterPoolReferenceBuilder(ClusterPoolReference instance) {
    this(instance,false);
  }
  public ClusterPoolReferenceBuilder(ClusterPoolReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClaimName(instance.getClaimName());
      this.withClaimedTimestamp(instance.getClaimedTimestamp());
      this.withNamespace(instance.getNamespace());
      this.withPoolName(instance.getPoolName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterPoolReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterPoolReference build() {
    ClusterPoolReference buildable = new ClusterPoolReference(fluent.getClaimName(),fluent.getClaimedTimestamp(),fluent.getNamespace(),fluent.getPoolName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}