package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterPoolSpecFluentImpl<A extends ClusterPoolSpecFluent<A>> extends BaseFluent<A> implements ClusterPoolSpecFluent<A>{
  public ClusterPoolSpecFluentImpl() {
  }
  public ClusterPoolSpecFluentImpl(ClusterPoolSpec instance) {
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withBaseDomain(instance.getBaseDomain());
      this.withClaimLifetime(instance.getClaimLifetime());
      this.withHibernateAfter(instance.getHibernateAfter());
      this.withImageSetRef(instance.getImageSetRef());
      this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit());
      this.withInstallConfigSecretTemplateRef(instance.getInstallConfigSecretTemplateRef());
      this.withLabels(instance.getLabels());
      this.withMaxConcurrent(instance.getMaxConcurrent());
      this.withMaxSize(instance.getMaxSize());
      this.withPlatform(instance.getPlatform());
      this.withPullSecretRef(instance.getPullSecretRef());
      this.withRunningCount(instance.getRunningCount());
      this.withSize(instance.getSize());
      this.withSkipMachinePools(instance.getSkipMachinePools());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Map<String,String> annotations;
  private String baseDomain;
  private ClusterPoolClaimLifetimeBuilder claimLifetime;
  private Duration hibernateAfter;
  private ClusterImageSetReferenceBuilder imageSetRef;
  private Integer installAttemptsLimit;
  private LocalObjectReferenceBuilder installConfigSecretTemplateRef;
  private Map<String,String> labels;
  private Integer maxConcurrent;
  private Integer maxSize;
  private PlatformBuilder platform;
  private LocalObjectReferenceBuilder pullSecretRef;
  private Integer runningCount;
  private Integer size;
  private Boolean skipMachinePools;
  private Map<String,Object> additionalProperties;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public String getBaseDomain() {
    return this.baseDomain;
  }
  public A withBaseDomain(String baseDomain) {
    this.baseDomain=baseDomain; return (A) this;
  }
  public Boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClaimLifetime instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterPoolClaimLifetime getClaimLifetime() {
    return this.claimLifetime!=null ?this.claimLifetime.build():null;
  }
  public ClusterPoolClaimLifetime buildClaimLifetime() {
    return this.claimLifetime!=null ?this.claimLifetime.build():null;
  }
  public A withClaimLifetime(ClusterPoolClaimLifetime claimLifetime) {
    _visitables.get("claimLifetime").remove(this.claimLifetime);
    if (claimLifetime!=null){ this.claimLifetime= new ClusterPoolClaimLifetimeBuilder(claimLifetime); _visitables.get("claimLifetime").add(this.claimLifetime);} else { this.claimLifetime = null; _visitables.get("claimLifetime").remove(this.claimLifetime); } return (A) this;
  }
  public Boolean hasClaimLifetime() {
    return this.claimLifetime != null;
  }
  public ClusterPoolSpecFluentImpl.ClaimLifetimeNested<A> withNewClaimLifetime() {
    return new ClusterPoolSpecFluentImpl.ClaimLifetimeNestedImpl();
  }
  public ClusterPoolSpecFluentImpl.ClaimLifetimeNested<A> withNewClaimLifetimeLike(ClusterPoolClaimLifetime item) {
    return new ClusterPoolSpecFluentImpl.ClaimLifetimeNestedImpl(item);
  }
  public ClusterPoolSpecFluentImpl.ClaimLifetimeNested<A> editClaimLifetime() {
    return withNewClaimLifetimeLike(getClaimLifetime());
  }
  public ClusterPoolSpecFluentImpl.ClaimLifetimeNested<A> editOrNewClaimLifetime() {
    return withNewClaimLifetimeLike(getClaimLifetime() != null ? getClaimLifetime(): new ClusterPoolClaimLifetimeBuilder().build());
  }
  public ClusterPoolSpecFluentImpl.ClaimLifetimeNested<A> editOrNewClaimLifetimeLike(ClusterPoolClaimLifetime item) {
    return withNewClaimLifetimeLike(getClaimLifetime() != null ? getClaimLifetime(): item);
  }
  public Duration getHibernateAfter() {
    return this.hibernateAfter;
  }
  public A withHibernateAfter(Duration hibernateAfter) {
    this.hibernateAfter=hibernateAfter; return (A) this;
  }
  public Boolean hasHibernateAfter() {
    return this.hibernateAfter != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImageSetRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterImageSetReference getImageSetRef() {
    return this.imageSetRef!=null ?this.imageSetRef.build():null;
  }
  public ClusterImageSetReference buildImageSetRef() {
    return this.imageSetRef!=null ?this.imageSetRef.build():null;
  }
  public A withImageSetRef(ClusterImageSetReference imageSetRef) {
    _visitables.get("imageSetRef").remove(this.imageSetRef);
    if (imageSetRef!=null){ this.imageSetRef= new ClusterImageSetReferenceBuilder(imageSetRef); _visitables.get("imageSetRef").add(this.imageSetRef);} else { this.imageSetRef = null; _visitables.get("imageSetRef").remove(this.imageSetRef); } return (A) this;
  }
  public Boolean hasImageSetRef() {
    return this.imageSetRef != null;
  }
  public A withNewImageSetRef(String name) {
    return (A)withImageSetRef(new ClusterImageSetReference(name));
  }
  public ClusterPoolSpecFluentImpl.ImageSetRefNested<A> withNewImageSetRef() {
    return new ClusterPoolSpecFluentImpl.ImageSetRefNestedImpl();
  }
  public ClusterPoolSpecFluentImpl.ImageSetRefNested<A> withNewImageSetRefLike(ClusterImageSetReference item) {
    return new ClusterPoolSpecFluentImpl.ImageSetRefNestedImpl(item);
  }
  public ClusterPoolSpecFluentImpl.ImageSetRefNested<A> editImageSetRef() {
    return withNewImageSetRefLike(getImageSetRef());
  }
  public ClusterPoolSpecFluentImpl.ImageSetRefNested<A> editOrNewImageSetRef() {
    return withNewImageSetRefLike(getImageSetRef() != null ? getImageSetRef(): new ClusterImageSetReferenceBuilder().build());
  }
  public ClusterPoolSpecFluentImpl.ImageSetRefNested<A> editOrNewImageSetRefLike(ClusterImageSetReference item) {
    return withNewImageSetRefLike(getImageSetRef() != null ? getImageSetRef(): item);
  }
  public Integer getInstallAttemptsLimit() {
    return this.installAttemptsLimit;
  }
  public A withInstallAttemptsLimit(Integer installAttemptsLimit) {
    this.installAttemptsLimit=installAttemptsLimit; return (A) this;
  }
  public Boolean hasInstallAttemptsLimit() {
    return this.installAttemptsLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildInstallConfigSecretTemplateRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getInstallConfigSecretTemplateRef() {
    return this.installConfigSecretTemplateRef!=null ?this.installConfigSecretTemplateRef.build():null;
  }
  public LocalObjectReference buildInstallConfigSecretTemplateRef() {
    return this.installConfigSecretTemplateRef!=null ?this.installConfigSecretTemplateRef.build():null;
  }
  public A withInstallConfigSecretTemplateRef(LocalObjectReference installConfigSecretTemplateRef) {
    _visitables.get("installConfigSecretTemplateRef").remove(this.installConfigSecretTemplateRef);
    if (installConfigSecretTemplateRef!=null){ this.installConfigSecretTemplateRef= new LocalObjectReferenceBuilder(installConfigSecretTemplateRef); _visitables.get("installConfigSecretTemplateRef").add(this.installConfigSecretTemplateRef);} else { this.installConfigSecretTemplateRef = null; _visitables.get("installConfigSecretTemplateRef").remove(this.installConfigSecretTemplateRef); } return (A) this;
  }
  public Boolean hasInstallConfigSecretTemplateRef() {
    return this.installConfigSecretTemplateRef != null;
  }
  public A withNewInstallConfigSecretTemplateRef(String name) {
    return (A)withInstallConfigSecretTemplateRef(new LocalObjectReference(name));
  }
  public ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRef() {
    return new ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNestedImpl();
  }
  public ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNested<A> withNewInstallConfigSecretTemplateRefLike(LocalObjectReference item) {
    return new ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNestedImpl(item);
  }
  public ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNested<A> editInstallConfigSecretTemplateRef() {
    return withNewInstallConfigSecretTemplateRefLike(getInstallConfigSecretTemplateRef());
  }
  public ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRef() {
    return withNewInstallConfigSecretTemplateRefLike(getInstallConfigSecretTemplateRef() != null ? getInstallConfigSecretTemplateRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNested<A> editOrNewInstallConfigSecretTemplateRefLike(LocalObjectReference item) {
    return withNewInstallConfigSecretTemplateRefLike(getInstallConfigSecretTemplateRef() != null ? getInstallConfigSecretTemplateRef(): item);
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public Boolean hasLabels() {
    return this.labels != null;
  }
  public Integer getMaxConcurrent() {
    return this.maxConcurrent;
  }
  public A withMaxConcurrent(Integer maxConcurrent) {
    this.maxConcurrent=maxConcurrent; return (A) this;
  }
  public Boolean hasMaxConcurrent() {
    return this.maxConcurrent != null;
  }
  public Integer getMaxSize() {
    return this.maxSize;
  }
  public A withMaxSize(Integer maxSize) {
    this.maxSize=maxSize; return (A) this;
  }
  public Boolean hasMaxSize() {
    return this.maxSize != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public Platform getPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public Platform buildPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public A withPlatform(Platform platform) {
    _visitables.get("platform").remove(this.platform);
    if (platform!=null){ this.platform= new PlatformBuilder(platform); _visitables.get("platform").add(this.platform);} else { this.platform = null; _visitables.get("platform").remove(this.platform); } return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public ClusterPoolSpecFluentImpl.PlatformNested<A> withNewPlatform() {
    return new ClusterPoolSpecFluentImpl.PlatformNestedImpl();
  }
  public ClusterPoolSpecFluentImpl.PlatformNested<A> withNewPlatformLike(Platform item) {
    return new ClusterPoolSpecFluentImpl.PlatformNestedImpl(item);
  }
  public ClusterPoolSpecFluentImpl.PlatformNested<A> editPlatform() {
    return withNewPlatformLike(getPlatform());
  }
  public ClusterPoolSpecFluentImpl.PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): new PlatformBuilder().build());
  }
  public ClusterPoolSpecFluentImpl.PlatformNested<A> editOrNewPlatformLike(Platform item) {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPullSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPullSecretRef() {
    return this.pullSecretRef!=null ?this.pullSecretRef.build():null;
  }
  public LocalObjectReference buildPullSecretRef() {
    return this.pullSecretRef!=null ?this.pullSecretRef.build():null;
  }
  public A withPullSecretRef(LocalObjectReference pullSecretRef) {
    _visitables.get("pullSecretRef").remove(this.pullSecretRef);
    if (pullSecretRef!=null){ this.pullSecretRef= new LocalObjectReferenceBuilder(pullSecretRef); _visitables.get("pullSecretRef").add(this.pullSecretRef);} else { this.pullSecretRef = null; _visitables.get("pullSecretRef").remove(this.pullSecretRef); } return (A) this;
  }
  public Boolean hasPullSecretRef() {
    return this.pullSecretRef != null;
  }
  public A withNewPullSecretRef(String name) {
    return (A)withPullSecretRef(new LocalObjectReference(name));
  }
  public ClusterPoolSpecFluentImpl.PullSecretRefNested<A> withNewPullSecretRef() {
    return new ClusterPoolSpecFluentImpl.PullSecretRefNestedImpl();
  }
  public ClusterPoolSpecFluentImpl.PullSecretRefNested<A> withNewPullSecretRefLike(LocalObjectReference item) {
    return new ClusterPoolSpecFluentImpl.PullSecretRefNestedImpl(item);
  }
  public ClusterPoolSpecFluentImpl.PullSecretRefNested<A> editPullSecretRef() {
    return withNewPullSecretRefLike(getPullSecretRef());
  }
  public ClusterPoolSpecFluentImpl.PullSecretRefNested<A> editOrNewPullSecretRef() {
    return withNewPullSecretRefLike(getPullSecretRef() != null ? getPullSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterPoolSpecFluentImpl.PullSecretRefNested<A> editOrNewPullSecretRefLike(LocalObjectReference item) {
    return withNewPullSecretRefLike(getPullSecretRef() != null ? getPullSecretRef(): item);
  }
  public Integer getRunningCount() {
    return this.runningCount;
  }
  public A withRunningCount(Integer runningCount) {
    this.runningCount=runningCount; return (A) this;
  }
  public Boolean hasRunningCount() {
    return this.runningCount != null;
  }
  public Integer getSize() {
    return this.size;
  }
  public A withSize(Integer size) {
    this.size=size; return (A) this;
  }
  public Boolean hasSize() {
    return this.size != null;
  }
  public Boolean getSkipMachinePools() {
    return this.skipMachinePools;
  }
  public A withSkipMachinePools(Boolean skipMachinePools) {
    this.skipMachinePools=skipMachinePools; return (A) this;
  }
  public Boolean hasSkipMachinePools() {
    return this.skipMachinePools != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterPoolSpecFluentImpl that = (ClusterPoolSpecFluentImpl) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(baseDomain, that.baseDomain)) return false;

    if (!java.util.Objects.equals(claimLifetime, that.claimLifetime)) return false;

    if (!java.util.Objects.equals(hibernateAfter, that.hibernateAfter)) return false;

    if (!java.util.Objects.equals(imageSetRef, that.imageSetRef)) return false;

    if (!java.util.Objects.equals(installAttemptsLimit, that.installAttemptsLimit)) return false;

    if (!java.util.Objects.equals(installConfigSecretTemplateRef, that.installConfigSecretTemplateRef)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(maxConcurrent, that.maxConcurrent)) return false;

    if (!java.util.Objects.equals(maxSize, that.maxSize)) return false;

    if (!java.util.Objects.equals(platform, that.platform)) return false;

    if (!java.util.Objects.equals(pullSecretRef, that.pullSecretRef)) return false;

    if (!java.util.Objects.equals(runningCount, that.runningCount)) return false;

    if (!java.util.Objects.equals(size, that.size)) return false;

    if (!java.util.Objects.equals(skipMachinePools, that.skipMachinePools)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  baseDomain,  claimLifetime,  hibernateAfter,  imageSetRef,  installAttemptsLimit,  installConfigSecretTemplateRef,  labels,  maxConcurrent,  maxSize,  platform,  pullSecretRef,  runningCount,  size,  skipMachinePools,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (claimLifetime != null) { sb.append("claimLifetime:"); sb.append(claimLifetime + ","); }
    if (hibernateAfter != null) { sb.append("hibernateAfter:"); sb.append(hibernateAfter + ","); }
    if (imageSetRef != null) { sb.append("imageSetRef:"); sb.append(imageSetRef + ","); }
    if (installAttemptsLimit != null) { sb.append("installAttemptsLimit:"); sb.append(installAttemptsLimit + ","); }
    if (installConfigSecretTemplateRef != null) { sb.append("installConfigSecretTemplateRef:"); sb.append(installConfigSecretTemplateRef + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (maxConcurrent != null) { sb.append("maxConcurrent:"); sb.append(maxConcurrent + ","); }
    if (maxSize != null) { sb.append("maxSize:"); sb.append(maxSize + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (pullSecretRef != null) { sb.append("pullSecretRef:"); sb.append(pullSecretRef + ","); }
    if (runningCount != null) { sb.append("runningCount:"); sb.append(runningCount + ","); }
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (skipMachinePools != null) { sb.append("skipMachinePools:"); sb.append(skipMachinePools + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSkipMachinePools() {
    return withSkipMachinePools(true);
  }
  class ClaimLifetimeNestedImpl<N> extends ClusterPoolClaimLifetimeFluentImpl<ClusterPoolSpecFluentImpl.ClaimLifetimeNested<N>> implements ClusterPoolSpecFluentImpl.ClaimLifetimeNested<N>,Nested<N>{
    ClaimLifetimeNestedImpl(ClusterPoolClaimLifetime item) {
      this.builder = new ClusterPoolClaimLifetimeBuilder(this, item);
    }
    ClaimLifetimeNestedImpl() {
      this.builder = new ClusterPoolClaimLifetimeBuilder(this);
    }
    ClusterPoolClaimLifetimeBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluentImpl.this.withClaimLifetime(builder.build());
    }
    public N endClaimLifetime() {
      return and();
    }
    
  }
  class ImageSetRefNestedImpl<N> extends ClusterImageSetReferenceFluentImpl<ClusterPoolSpecFluentImpl.ImageSetRefNested<N>> implements ClusterPoolSpecFluentImpl.ImageSetRefNested<N>,Nested<N>{
    ImageSetRefNestedImpl(ClusterImageSetReference item) {
      this.builder = new ClusterImageSetReferenceBuilder(this, item);
    }
    ImageSetRefNestedImpl() {
      this.builder = new ClusterImageSetReferenceBuilder(this);
    }
    ClusterImageSetReferenceBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluentImpl.this.withImageSetRef(builder.build());
    }
    public N endImageSetRef() {
      return and();
    }
    
  }
  class InstallConfigSecretTemplateRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNested<N>> implements ClusterPoolSpecFluentImpl.InstallConfigSecretTemplateRefNested<N>,Nested<N>{
    InstallConfigSecretTemplateRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    InstallConfigSecretTemplateRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluentImpl.this.withInstallConfigSecretTemplateRef(builder.build());
    }
    public N endInstallConfigSecretTemplateRef() {
      return and();
    }
    
  }
  class PlatformNestedImpl<N> extends PlatformFluentImpl<ClusterPoolSpecFluentImpl.PlatformNested<N>> implements ClusterPoolSpecFluentImpl.PlatformNested<N>,Nested<N>{
    PlatformNestedImpl(Platform item) {
      this.builder = new PlatformBuilder(this, item);
    }
    PlatformNestedImpl() {
      this.builder = new PlatformBuilder(this);
    }
    PlatformBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluentImpl.this.withPlatform(builder.build());
    }
    public N endPlatform() {
      return and();
    }
    
  }
  class PullSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterPoolSpecFluentImpl.PullSecretRefNested<N>> implements ClusterPoolSpecFluentImpl.PullSecretRefNested<N>,Nested<N>{
    PullSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    PullSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterPoolSpecFluentImpl.this.withPullSecretRef(builder.build());
    }
    public N endPullSecretRef() {
      return and();
    }
    
  }
  
}