package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterPoolStatusBuilder extends ClusterPoolStatusFluentImpl<ClusterPoolStatusBuilder> implements VisitableBuilder<ClusterPoolStatus,ClusterPoolStatusBuilder>{
  public ClusterPoolStatusBuilder() {
    this(false);
  }
  public ClusterPoolStatusBuilder(Boolean validationEnabled) {
    this(new ClusterPoolStatus(), validationEnabled);
  }
  public ClusterPoolStatusBuilder(ClusterPoolStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterPoolStatusBuilder(ClusterPoolStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterPoolStatus(), validationEnabled);
  }
  public ClusterPoolStatusBuilder(ClusterPoolStatusFluent<?> fluent,ClusterPoolStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterPoolStatusBuilder(ClusterPoolStatusFluent<?> fluent,ClusterPoolStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withReady(instance.getReady());
      fluent.withSize(instance.getSize());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterPoolStatusBuilder(ClusterPoolStatus instance) {
    this(instance,false);
  }
  public ClusterPoolStatusBuilder(ClusterPoolStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withReady(instance.getReady());
      this.withSize(instance.getSize());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterPoolStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterPoolStatus build() {
    ClusterPoolStatus buildable = new ClusterPoolStatus(fluent.getConditions(),fluent.getReady(),fluent.getSize());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}