package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterPoolStatusFluentImpl<A extends ClusterPoolStatusFluent<A>> extends BaseFluent<A> implements ClusterPoolStatusFluent<A>{
  public ClusterPoolStatusFluentImpl() {
  }
  public ClusterPoolStatusFluentImpl(ClusterPoolStatus instance) {
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withReady(instance.getReady());
      this.withSize(instance.getSize());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ClusterPoolConditionBuilder> conditions = new ArrayList<ClusterPoolConditionBuilder>();
  private Integer ready;
  private Integer size;
  private Map<String,Object> additionalProperties;
  public A addToConditions(int index,ClusterPoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterPoolConditionBuilder>();}
    ClusterPoolConditionBuilder builder = new ClusterPoolConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ClusterPoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterPoolConditionBuilder>();}
    ClusterPoolConditionBuilder builder = new ClusterPoolConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.hive.v1.ClusterPoolCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterPoolConditionBuilder>();}
    for (ClusterPoolCondition item : items) {ClusterPoolConditionBuilder builder = new ClusterPoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ClusterPoolCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterPoolConditionBuilder>();}
    for (ClusterPoolCondition item : items) {ClusterPoolConditionBuilder builder = new ClusterPoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.hive.v1.ClusterPoolCondition... items) {
    for (ClusterPoolCondition item : items) {ClusterPoolConditionBuilder builder = new ClusterPoolConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ClusterPoolCondition> items) {
    for (ClusterPoolCondition item : items) {ClusterPoolConditionBuilder builder = new ClusterPoolConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ClusterPoolConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ClusterPoolConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ClusterPoolConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterPoolCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ClusterPoolCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ClusterPoolCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ClusterPoolCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ClusterPoolCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ClusterPoolCondition buildMatchingCondition(Predicate<ClusterPoolConditionBuilder> predicate) {
    for (ClusterPoolConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ClusterPoolConditionBuilder> predicate) {
    for (ClusterPoolConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ClusterPoolCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ClusterPoolCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.hive.v1.ClusterPoolCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ClusterPoolCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ClusterPoolStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new ClusterPoolStatusFluentImpl.ConditionsNestedImpl();
  }
  public ClusterPoolStatusFluentImpl.ConditionsNested<A> addNewConditionLike(ClusterPoolCondition item) {
    return new ClusterPoolStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ClusterPoolStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,ClusterPoolCondition item) {
    return new ClusterPoolStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ClusterPoolStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterPoolStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ClusterPoolStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterPoolStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ClusterPoolConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Integer getReady() {
    return this.ready;
  }
  public A withReady(Integer ready) {
    this.ready=ready; return (A) this;
  }
  public Boolean hasReady() {
    return this.ready != null;
  }
  public Integer getSize() {
    return this.size;
  }
  public A withSize(Integer size) {
    this.size=size; return (A) this;
  }
  public Boolean hasSize() {
    return this.size != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterPoolStatusFluentImpl that = (ClusterPoolStatusFluentImpl) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(ready, that.ready)) return false;

    if (!java.util.Objects.equals(size, that.size)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  ready,  size,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (ready != null) { sb.append("ready:"); sb.append(ready + ","); }
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ClusterPoolConditionFluentImpl<ClusterPoolStatusFluentImpl.ConditionsNested<N>> implements ClusterPoolStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,ClusterPoolCondition item) {
      this.index = index;
      this.builder = new ClusterPoolConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterPoolConditionBuilder(this);
    }
    ClusterPoolConditionBuilder builder;
    int index;
    public N and() {
      return (N) ClusterPoolStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}