package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterProvisionListBuilder extends ClusterProvisionListFluentImpl<ClusterProvisionListBuilder> implements VisitableBuilder<ClusterProvisionList,ClusterProvisionListBuilder>{
  public ClusterProvisionListBuilder() {
    this(false);
  }
  public ClusterProvisionListBuilder(Boolean validationEnabled) {
    this(new ClusterProvisionList(), validationEnabled);
  }
  public ClusterProvisionListBuilder(ClusterProvisionListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterProvisionListBuilder(ClusterProvisionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterProvisionList(), validationEnabled);
  }
  public ClusterProvisionListBuilder(ClusterProvisionListFluent<?> fluent,ClusterProvisionList instance) {
    this(fluent, instance, false);
  }
  public ClusterProvisionListBuilder(ClusterProvisionListFluent<?> fluent,ClusterProvisionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterProvisionListBuilder(ClusterProvisionList instance) {
    this(instance,false);
  }
  public ClusterProvisionListBuilder(ClusterProvisionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterProvisionListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterProvisionList build() {
    ClusterProvisionList buildable = new ClusterProvisionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}