package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterStateSpecBuilder extends ClusterStateSpecFluentImpl<ClusterStateSpecBuilder> implements VisitableBuilder<ClusterStateSpec,ClusterStateSpecBuilder>{
  public ClusterStateSpecBuilder() {
    this(false);
  }
  public ClusterStateSpecBuilder(Boolean validationEnabled) {
    this(new ClusterStateSpec(), validationEnabled);
  }
  public ClusterStateSpecBuilder(ClusterStateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterStateSpecBuilder(ClusterStateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterStateSpec(), validationEnabled);
  }
  public ClusterStateSpecBuilder(ClusterStateSpecFluent<?> fluent,ClusterStateSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterStateSpecBuilder(ClusterStateSpecFluent<?> fluent,ClusterStateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterStateSpecBuilder(ClusterStateSpec instance) {
    this(instance,false);
  }
  public ClusterStateSpecBuilder(ClusterStateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterStateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterStateSpec build() {
    ClusterStateSpec buildable = new ClusterStateSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}