package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolBuilder extends MachinePoolFluentImpl<MachinePoolBuilder> implements VisitableBuilder<MachinePool,MachinePoolBuilder>{
  public MachinePoolBuilder() {
    this(false);
  }
  public MachinePoolBuilder(Boolean validationEnabled) {
    this(new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePool(), validationEnabled);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance) {
    this(fluent, instance, false);
  }
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolBuilder(MachinePool instance) {
    this(instance,false);
  }
  public MachinePoolBuilder(MachinePool instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePool build() {
    MachinePool buildable = new MachinePool(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}