package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolListBuilder extends MachinePoolListFluentImpl<MachinePoolListBuilder> implements VisitableBuilder<MachinePoolList,MachinePoolListBuilder>{
  public MachinePoolListBuilder() {
    this(false);
  }
  public MachinePoolListBuilder(Boolean validationEnabled) {
    this(new MachinePoolList(), validationEnabled);
  }
  public MachinePoolListBuilder(MachinePoolListFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolListBuilder(MachinePoolListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolList(), validationEnabled);
  }
  public MachinePoolListBuilder(MachinePoolListFluent<?> fluent,MachinePoolList instance) {
    this(fluent, instance, false);
  }
  public MachinePoolListBuilder(MachinePoolListFluent<?> fluent,MachinePoolList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolListBuilder(MachinePoolList instance) {
    this(instance,false);
  }
  public MachinePoolListBuilder(MachinePoolList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolListFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolList build() {
    MachinePoolList buildable = new MachinePoolList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}