package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolNameLeaseBuilder extends MachinePoolNameLeaseFluentImpl<MachinePoolNameLeaseBuilder> implements VisitableBuilder<MachinePoolNameLease,MachinePoolNameLeaseBuilder>{
  public MachinePoolNameLeaseBuilder() {
    this(false);
  }
  public MachinePoolNameLeaseBuilder(Boolean validationEnabled) {
    this(new MachinePoolNameLease(), validationEnabled);
  }
  public MachinePoolNameLeaseBuilder(MachinePoolNameLeaseFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolNameLeaseBuilder(MachinePoolNameLeaseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolNameLease(), validationEnabled);
  }
  public MachinePoolNameLeaseBuilder(MachinePoolNameLeaseFluent<?> fluent,MachinePoolNameLease instance) {
    this(fluent, instance, false);
  }
  public MachinePoolNameLeaseBuilder(MachinePoolNameLeaseFluent<?> fluent,MachinePoolNameLease instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolNameLeaseBuilder(MachinePoolNameLease instance) {
    this(instance,false);
  }
  public MachinePoolNameLeaseBuilder(MachinePoolNameLease instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolNameLeaseFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolNameLease build() {
    MachinePoolNameLease buildable = new MachinePoolNameLease(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}