package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolStatusBuilder extends MachinePoolStatusFluentImpl<MachinePoolStatusBuilder> implements VisitableBuilder<MachinePoolStatus,MachinePoolStatusBuilder>{
  public MachinePoolStatusBuilder() {
    this(false);
  }
  public MachinePoolStatusBuilder(Boolean validationEnabled) {
    this(new MachinePoolStatus(), validationEnabled);
  }
  public MachinePoolStatusBuilder(MachinePoolStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolStatusBuilder(MachinePoolStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolStatus(), validationEnabled);
  }
  public MachinePoolStatusBuilder(MachinePoolStatusFluent<?> fluent,MachinePoolStatus instance) {
    this(fluent, instance, false);
  }
  public MachinePoolStatusBuilder(MachinePoolStatusFluent<?> fluent,MachinePoolStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withMachineSets(instance.getMachineSets());
      fluent.withReplicas(instance.getReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolStatusBuilder(MachinePoolStatus instance) {
    this(instance,false);
  }
  public MachinePoolStatusBuilder(MachinePoolStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withMachineSets(instance.getMachineSets());
      this.withReplicas(instance.getReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachinePoolStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolStatus build() {
    MachinePoolStatus buildable = new MachinePoolStatus(fluent.getConditions(),fluent.getMachineSets(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}