package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManageDNSConfigBuilder extends ManageDNSConfigFluentImpl<ManageDNSConfigBuilder> implements VisitableBuilder<ManageDNSConfig,ManageDNSConfigBuilder>{
  public ManageDNSConfigBuilder() {
    this(false);
  }
  public ManageDNSConfigBuilder(Boolean validationEnabled) {
    this(new ManageDNSConfig(), validationEnabled);
  }
  public ManageDNSConfigBuilder(ManageDNSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ManageDNSConfigBuilder(ManageDNSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManageDNSConfig(), validationEnabled);
  }
  public ManageDNSConfigBuilder(ManageDNSConfigFluent<?> fluent,ManageDNSConfig instance) {
    this(fluent, instance, false);
  }
  public ManageDNSConfigBuilder(ManageDNSConfigFluent<?> fluent,ManageDNSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withAzure(instance.getAzure());
      fluent.withDomains(instance.getDomains());
      fluent.withGcp(instance.getGcp());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManageDNSConfigBuilder(ManageDNSConfig instance) {
    this(instance,false);
  }
  public ManageDNSConfigBuilder(ManageDNSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withDomains(instance.getDomains());
      this.withGcp(instance.getGcp());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManageDNSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ManageDNSConfig build() {
    ManageDNSConfig buildable = new ManageDNSConfig(fluent.getAws(),fluent.getAzure(),fluent.getDomains(),fluent.getGcp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}