package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProvisioningFluentImpl<A extends ProvisioningFluent<A>> extends BaseFluent<A> implements ProvisioningFluent<A>{
  public ProvisioningFluentImpl() {
  }
  public ProvisioningFluentImpl(Provisioning instance) {
    if (instance != null) {
      this.withImageSetRef(instance.getImageSetRef());
      this.withInstallConfigSecretRef(instance.getInstallConfigSecretRef());
      this.withInstallerEnv(instance.getInstallerEnv());
      this.withInstallerImageOverride(instance.getInstallerImageOverride());
      this.withManifestsConfigMapRef(instance.getManifestsConfigMapRef());
      this.withReleaseImage(instance.getReleaseImage());
      this.withSshKnownHosts(instance.getSshKnownHosts());
      this.withSshPrivateKeySecretRef(instance.getSshPrivateKeySecretRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ClusterImageSetReferenceBuilder imageSetRef;
  private LocalObjectReferenceBuilder installConfigSecretRef;
  private List<EnvVar> installerEnv = new ArrayList<EnvVar>();
  private String installerImageOverride;
  private LocalObjectReferenceBuilder manifestsConfigMapRef;
  private String releaseImage;
  private List<String> sshKnownHosts = new ArrayList<String>();
  private LocalObjectReferenceBuilder sshPrivateKeySecretRef;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildImageSetRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterImageSetReference getImageSetRef() {
    return this.imageSetRef!=null ?this.imageSetRef.build():null;
  }
  public ClusterImageSetReference buildImageSetRef() {
    return this.imageSetRef!=null ?this.imageSetRef.build():null;
  }
  public A withImageSetRef(ClusterImageSetReference imageSetRef) {
    _visitables.get("imageSetRef").remove(this.imageSetRef);
    if (imageSetRef!=null){ this.imageSetRef= new ClusterImageSetReferenceBuilder(imageSetRef); _visitables.get("imageSetRef").add(this.imageSetRef);} else { this.imageSetRef = null; _visitables.get("imageSetRef").remove(this.imageSetRef); } return (A) this;
  }
  public Boolean hasImageSetRef() {
    return this.imageSetRef != null;
  }
  public A withNewImageSetRef(String name) {
    return (A)withImageSetRef(new ClusterImageSetReference(name));
  }
  public ProvisioningFluentImpl.ImageSetRefNested<A> withNewImageSetRef() {
    return new ProvisioningFluentImpl.ImageSetRefNestedImpl();
  }
  public ProvisioningFluentImpl.ImageSetRefNested<A> withNewImageSetRefLike(ClusterImageSetReference item) {
    return new ProvisioningFluentImpl.ImageSetRefNestedImpl(item);
  }
  public ProvisioningFluentImpl.ImageSetRefNested<A> editImageSetRef() {
    return withNewImageSetRefLike(getImageSetRef());
  }
  public ProvisioningFluentImpl.ImageSetRefNested<A> editOrNewImageSetRef() {
    return withNewImageSetRefLike(getImageSetRef() != null ? getImageSetRef(): new ClusterImageSetReferenceBuilder().build());
  }
  public ProvisioningFluentImpl.ImageSetRefNested<A> editOrNewImageSetRefLike(ClusterImageSetReference item) {
    return withNewImageSetRefLike(getImageSetRef() != null ? getImageSetRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildInstallConfigSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getInstallConfigSecretRef() {
    return this.installConfigSecretRef!=null ?this.installConfigSecretRef.build():null;
  }
  public LocalObjectReference buildInstallConfigSecretRef() {
    return this.installConfigSecretRef!=null ?this.installConfigSecretRef.build():null;
  }
  public A withInstallConfigSecretRef(LocalObjectReference installConfigSecretRef) {
    _visitables.get("installConfigSecretRef").remove(this.installConfigSecretRef);
    if (installConfigSecretRef!=null){ this.installConfigSecretRef= new LocalObjectReferenceBuilder(installConfigSecretRef); _visitables.get("installConfigSecretRef").add(this.installConfigSecretRef);} else { this.installConfigSecretRef = null; _visitables.get("installConfigSecretRef").remove(this.installConfigSecretRef); } return (A) this;
  }
  public Boolean hasInstallConfigSecretRef() {
    return this.installConfigSecretRef != null;
  }
  public A withNewInstallConfigSecretRef(String name) {
    return (A)withInstallConfigSecretRef(new LocalObjectReference(name));
  }
  public ProvisioningFluentImpl.InstallConfigSecretRefNested<A> withNewInstallConfigSecretRef() {
    return new ProvisioningFluentImpl.InstallConfigSecretRefNestedImpl();
  }
  public ProvisioningFluentImpl.InstallConfigSecretRefNested<A> withNewInstallConfigSecretRefLike(LocalObjectReference item) {
    return new ProvisioningFluentImpl.InstallConfigSecretRefNestedImpl(item);
  }
  public ProvisioningFluentImpl.InstallConfigSecretRefNested<A> editInstallConfigSecretRef() {
    return withNewInstallConfigSecretRefLike(getInstallConfigSecretRef());
  }
  public ProvisioningFluentImpl.InstallConfigSecretRefNested<A> editOrNewInstallConfigSecretRef() {
    return withNewInstallConfigSecretRefLike(getInstallConfigSecretRef() != null ? getInstallConfigSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ProvisioningFluentImpl.InstallConfigSecretRefNested<A> editOrNewInstallConfigSecretRefLike(LocalObjectReference item) {
    return withNewInstallConfigSecretRefLike(getInstallConfigSecretRef() != null ? getInstallConfigSecretRef(): item);
  }
  public A addToInstallerEnv(int index,EnvVar item) {
    if (this.installerEnv == null) {this.installerEnv = new ArrayList<EnvVar>();}
    this.installerEnv.add(index, item);
    return (A)this;
  }
  public A setToInstallerEnv(int index,EnvVar item) {
    if (this.installerEnv == null) {this.installerEnv = new ArrayList<EnvVar>();}
    this.installerEnv.set(index, item); return (A)this;
  }
  public A addToInstallerEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.installerEnv == null) {this.installerEnv = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.installerEnv.add(item);} return (A)this;
  }
  public A addAllToInstallerEnv(Collection<EnvVar> items) {
    if (this.installerEnv == null) {this.installerEnv = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.installerEnv.add(item);} return (A)this;
  }
  public A removeFromInstallerEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {if (this.installerEnv!= null){ this.installerEnv.remove(item);}} return (A)this;
  }
  public A removeAllFromInstallerEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {if (this.installerEnv!= null){ this.installerEnv.remove(item);}} return (A)this;
  }
  public List<EnvVar> getInstallerEnv() {
    return this.installerEnv;
  }
  public EnvVar getInstallerEnv(int index) {
    return this.installerEnv.get(index);
  }
  public EnvVar getFirstInstallerEnv() {
    return this.installerEnv.get(0);
  }
  public EnvVar getLastInstallerEnv() {
    return this.installerEnv.get(installerEnv.size() - 1);
  }
  public EnvVar getMatchingInstallerEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: installerEnv) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingInstallerEnv(Predicate<EnvVar> predicate) {
    for (EnvVar item: installerEnv) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInstallerEnv(List<EnvVar> installerEnv) {
    if (installerEnv != null) {this.installerEnv = new ArrayList(); for (EnvVar item : installerEnv){this.addToInstallerEnv(item);}} else { this.installerEnv = null;} return (A) this;
  }
  public A withInstallerEnv(io.fabric8.kubernetes.api.model.EnvVar... installerEnv) {
    if (this.installerEnv != null) {this.installerEnv.clear(); _visitables.remove("installerEnv"); }
    if (installerEnv != null) {for (EnvVar item :installerEnv){ this.addToInstallerEnv(item);}} return (A) this;
  }
  public Boolean hasInstallerEnv() {
    return installerEnv != null && !installerEnv.isEmpty();
  }
  public String getInstallerImageOverride() {
    return this.installerImageOverride;
  }
  public A withInstallerImageOverride(String installerImageOverride) {
    this.installerImageOverride=installerImageOverride; return (A) this;
  }
  public Boolean hasInstallerImageOverride() {
    return this.installerImageOverride != null;
  }
  
  /**
   * This method has been deprecated, please use method buildManifestsConfigMapRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getManifestsConfigMapRef() {
    return this.manifestsConfigMapRef!=null ?this.manifestsConfigMapRef.build():null;
  }
  public LocalObjectReference buildManifestsConfigMapRef() {
    return this.manifestsConfigMapRef!=null ?this.manifestsConfigMapRef.build():null;
  }
  public A withManifestsConfigMapRef(LocalObjectReference manifestsConfigMapRef) {
    _visitables.get("manifestsConfigMapRef").remove(this.manifestsConfigMapRef);
    if (manifestsConfigMapRef!=null){ this.manifestsConfigMapRef= new LocalObjectReferenceBuilder(manifestsConfigMapRef); _visitables.get("manifestsConfigMapRef").add(this.manifestsConfigMapRef);} else { this.manifestsConfigMapRef = null; _visitables.get("manifestsConfigMapRef").remove(this.manifestsConfigMapRef); } return (A) this;
  }
  public Boolean hasManifestsConfigMapRef() {
    return this.manifestsConfigMapRef != null;
  }
  public A withNewManifestsConfigMapRef(String name) {
    return (A)withManifestsConfigMapRef(new LocalObjectReference(name));
  }
  public ProvisioningFluentImpl.ManifestsConfigMapRefNested<A> withNewManifestsConfigMapRef() {
    return new ProvisioningFluentImpl.ManifestsConfigMapRefNestedImpl();
  }
  public ProvisioningFluentImpl.ManifestsConfigMapRefNested<A> withNewManifestsConfigMapRefLike(LocalObjectReference item) {
    return new ProvisioningFluentImpl.ManifestsConfigMapRefNestedImpl(item);
  }
  public ProvisioningFluentImpl.ManifestsConfigMapRefNested<A> editManifestsConfigMapRef() {
    return withNewManifestsConfigMapRefLike(getManifestsConfigMapRef());
  }
  public ProvisioningFluentImpl.ManifestsConfigMapRefNested<A> editOrNewManifestsConfigMapRef() {
    return withNewManifestsConfigMapRefLike(getManifestsConfigMapRef() != null ? getManifestsConfigMapRef(): new LocalObjectReferenceBuilder().build());
  }
  public ProvisioningFluentImpl.ManifestsConfigMapRefNested<A> editOrNewManifestsConfigMapRefLike(LocalObjectReference item) {
    return withNewManifestsConfigMapRefLike(getManifestsConfigMapRef() != null ? getManifestsConfigMapRef(): item);
  }
  public String getReleaseImage() {
    return this.releaseImage;
  }
  public A withReleaseImage(String releaseImage) {
    this.releaseImage=releaseImage; return (A) this;
  }
  public Boolean hasReleaseImage() {
    return this.releaseImage != null;
  }
  public A addToSshKnownHosts(int index,String item) {
    if (this.sshKnownHosts == null) {this.sshKnownHosts = new ArrayList<String>();}
    this.sshKnownHosts.add(index, item);
    return (A)this;
  }
  public A setToSshKnownHosts(int index,String item) {
    if (this.sshKnownHosts == null) {this.sshKnownHosts = new ArrayList<String>();}
    this.sshKnownHosts.set(index, item); return (A)this;
  }
  public A addToSshKnownHosts(java.lang.String... items) {
    if (this.sshKnownHosts == null) {this.sshKnownHosts = new ArrayList<String>();}
    for (String item : items) {this.sshKnownHosts.add(item);} return (A)this;
  }
  public A addAllToSshKnownHosts(Collection<String> items) {
    if (this.sshKnownHosts == null) {this.sshKnownHosts = new ArrayList<String>();}
    for (String item : items) {this.sshKnownHosts.add(item);} return (A)this;
  }
  public A removeFromSshKnownHosts(java.lang.String... items) {
    for (String item : items) {if (this.sshKnownHosts!= null){ this.sshKnownHosts.remove(item);}} return (A)this;
  }
  public A removeAllFromSshKnownHosts(Collection<String> items) {
    for (String item : items) {if (this.sshKnownHosts!= null){ this.sshKnownHosts.remove(item);}} return (A)this;
  }
  public List<String> getSshKnownHosts() {
    return this.sshKnownHosts;
  }
  public String getSshKnownHost(int index) {
    return this.sshKnownHosts.get(index);
  }
  public String getFirstSshKnownHost() {
    return this.sshKnownHosts.get(0);
  }
  public String getLastSshKnownHost() {
    return this.sshKnownHosts.get(sshKnownHosts.size() - 1);
  }
  public String getMatchingSshKnownHost(Predicate<String> predicate) {
    for (String item: sshKnownHosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSshKnownHost(Predicate<String> predicate) {
    for (String item: sshKnownHosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSshKnownHosts(List<String> sshKnownHosts) {
    if (sshKnownHosts != null) {this.sshKnownHosts = new ArrayList(); for (String item : sshKnownHosts){this.addToSshKnownHosts(item);}} else { this.sshKnownHosts = null;} return (A) this;
  }
  public A withSshKnownHosts(java.lang.String... sshKnownHosts) {
    if (this.sshKnownHosts != null) {this.sshKnownHosts.clear(); _visitables.remove("sshKnownHosts"); }
    if (sshKnownHosts != null) {for (String item :sshKnownHosts){ this.addToSshKnownHosts(item);}} return (A) this;
  }
  public Boolean hasSshKnownHosts() {
    return sshKnownHosts != null && !sshKnownHosts.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildSshPrivateKeySecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSshPrivateKeySecretRef() {
    return this.sshPrivateKeySecretRef!=null ?this.sshPrivateKeySecretRef.build():null;
  }
  public LocalObjectReference buildSshPrivateKeySecretRef() {
    return this.sshPrivateKeySecretRef!=null ?this.sshPrivateKeySecretRef.build():null;
  }
  public A withSshPrivateKeySecretRef(LocalObjectReference sshPrivateKeySecretRef) {
    _visitables.get("sshPrivateKeySecretRef").remove(this.sshPrivateKeySecretRef);
    if (sshPrivateKeySecretRef!=null){ this.sshPrivateKeySecretRef= new LocalObjectReferenceBuilder(sshPrivateKeySecretRef); _visitables.get("sshPrivateKeySecretRef").add(this.sshPrivateKeySecretRef);} else { this.sshPrivateKeySecretRef = null; _visitables.get("sshPrivateKeySecretRef").remove(this.sshPrivateKeySecretRef); } return (A) this;
  }
  public Boolean hasSshPrivateKeySecretRef() {
    return this.sshPrivateKeySecretRef != null;
  }
  public A withNewSshPrivateKeySecretRef(String name) {
    return (A)withSshPrivateKeySecretRef(new LocalObjectReference(name));
  }
  public ProvisioningFluentImpl.SshPrivateKeySecretRefNested<A> withNewSshPrivateKeySecretRef() {
    return new ProvisioningFluentImpl.SshPrivateKeySecretRefNestedImpl();
  }
  public ProvisioningFluentImpl.SshPrivateKeySecretRefNested<A> withNewSshPrivateKeySecretRefLike(LocalObjectReference item) {
    return new ProvisioningFluentImpl.SshPrivateKeySecretRefNestedImpl(item);
  }
  public ProvisioningFluentImpl.SshPrivateKeySecretRefNested<A> editSshPrivateKeySecretRef() {
    return withNewSshPrivateKeySecretRefLike(getSshPrivateKeySecretRef());
  }
  public ProvisioningFluentImpl.SshPrivateKeySecretRefNested<A> editOrNewSshPrivateKeySecretRef() {
    return withNewSshPrivateKeySecretRefLike(getSshPrivateKeySecretRef() != null ? getSshPrivateKeySecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ProvisioningFluentImpl.SshPrivateKeySecretRefNested<A> editOrNewSshPrivateKeySecretRefLike(LocalObjectReference item) {
    return withNewSshPrivateKeySecretRefLike(getSshPrivateKeySecretRef() != null ? getSshPrivateKeySecretRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProvisioningFluentImpl that = (ProvisioningFluentImpl) o;
    if (!java.util.Objects.equals(imageSetRef, that.imageSetRef)) return false;

    if (!java.util.Objects.equals(installConfigSecretRef, that.installConfigSecretRef)) return false;

    if (!java.util.Objects.equals(installerEnv, that.installerEnv)) return false;

    if (!java.util.Objects.equals(installerImageOverride, that.installerImageOverride)) return false;

    if (!java.util.Objects.equals(manifestsConfigMapRef, that.manifestsConfigMapRef)) return false;

    if (!java.util.Objects.equals(releaseImage, that.releaseImage)) return false;

    if (!java.util.Objects.equals(sshKnownHosts, that.sshKnownHosts)) return false;

    if (!java.util.Objects.equals(sshPrivateKeySecretRef, that.sshPrivateKeySecretRef)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(imageSetRef,  installConfigSecretRef,  installerEnv,  installerImageOverride,  manifestsConfigMapRef,  releaseImage,  sshKnownHosts,  sshPrivateKeySecretRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (imageSetRef != null) { sb.append("imageSetRef:"); sb.append(imageSetRef + ","); }
    if (installConfigSecretRef != null) { sb.append("installConfigSecretRef:"); sb.append(installConfigSecretRef + ","); }
    if (installerEnv != null && !installerEnv.isEmpty()) { sb.append("installerEnv:"); sb.append(installerEnv + ","); }
    if (installerImageOverride != null) { sb.append("installerImageOverride:"); sb.append(installerImageOverride + ","); }
    if (manifestsConfigMapRef != null) { sb.append("manifestsConfigMapRef:"); sb.append(manifestsConfigMapRef + ","); }
    if (releaseImage != null) { sb.append("releaseImage:"); sb.append(releaseImage + ","); }
    if (sshKnownHosts != null && !sshKnownHosts.isEmpty()) { sb.append("sshKnownHosts:"); sb.append(sshKnownHosts + ","); }
    if (sshPrivateKeySecretRef != null) { sb.append("sshPrivateKeySecretRef:"); sb.append(sshPrivateKeySecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageSetRefNestedImpl<N> extends ClusterImageSetReferenceFluentImpl<ProvisioningFluentImpl.ImageSetRefNested<N>> implements ProvisioningFluentImpl.ImageSetRefNested<N>,Nested<N>{
    ImageSetRefNestedImpl(ClusterImageSetReference item) {
      this.builder = new ClusterImageSetReferenceBuilder(this, item);
    }
    ImageSetRefNestedImpl() {
      this.builder = new ClusterImageSetReferenceBuilder(this);
    }
    ClusterImageSetReferenceBuilder builder;
    public N and() {
      return (N) ProvisioningFluentImpl.this.withImageSetRef(builder.build());
    }
    public N endImageSetRef() {
      return and();
    }
    
  }
  class InstallConfigSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ProvisioningFluentImpl.InstallConfigSecretRefNested<N>> implements ProvisioningFluentImpl.InstallConfigSecretRefNested<N>,Nested<N>{
    InstallConfigSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    InstallConfigSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ProvisioningFluentImpl.this.withInstallConfigSecretRef(builder.build());
    }
    public N endInstallConfigSecretRef() {
      return and();
    }
    
  }
  class ManifestsConfigMapRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ProvisioningFluentImpl.ManifestsConfigMapRefNested<N>> implements ProvisioningFluentImpl.ManifestsConfigMapRefNested<N>,Nested<N>{
    ManifestsConfigMapRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ManifestsConfigMapRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ProvisioningFluentImpl.this.withManifestsConfigMapRef(builder.build());
    }
    public N endManifestsConfigMapRef() {
      return and();
    }
    
  }
  class SshPrivateKeySecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ProvisioningFluentImpl.SshPrivateKeySecretRefNested<N>> implements ProvisioningFluentImpl.SshPrivateKeySecretRefNested<N>,Nested<N>{
    SshPrivateKeySecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SshPrivateKeySecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ProvisioningFluentImpl.this.withSshPrivateKeySecretRef(builder.build());
    }
    public N endSshPrivateKeySecretRef() {
      return and();
    }
    
  }
  
}