package io.fabric8.openshift.api.model.hive.vsphere.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface MachinePoolFluent<A extends MachinePoolFluent<A>> extends Fluent<A>{
  public Integer getCoresPerSocket();
  public A withCoresPerSocket(Integer coresPerSocket);
  public Boolean hasCoresPerSocket();
  public Integer getCpus();
  public A withCpus(Integer cpus);
  public Boolean hasCpus();
  public Long getMemoryMB();
  public A withMemoryMB(Long memoryMB);
  public Boolean hasMemoryMB();
  
  /**
   * This method has been deprecated, please use method buildOsDisk instead.
   * @return The buildable object.
   */
  @Deprecated
  public OSDisk getOsDisk();
  public OSDisk buildOsDisk();
  public A withOsDisk(OSDisk osDisk);
  public Boolean hasOsDisk();
  public A withNewOsDisk(Integer diskSizeGB);
  public MachinePoolFluent.OsDiskNested<A> withNewOsDisk();
  public MachinePoolFluent.OsDiskNested<A> withNewOsDiskLike(OSDisk item);
  public MachinePoolFluent.OsDiskNested<A> editOsDisk();
  public MachinePoolFluent.OsDiskNested<A> editOrNewOsDisk();
  public MachinePoolFluent.OsDiskNested<A> editOrNewOsDiskLike(OSDisk item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface OsDiskNested<N> extends Nested<N>,OSDiskFluent<MachinePoolFluent.OsDiskNested<N>>{
    public N and();
    public N endOsDisk();
    
  }
  
}