package io.fabric8.openshift.api.model.hive.vsphere.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    if (instance != null) {
      this.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      this.withCluster(instance.getCluster());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withDatacenter(instance.getDatacenter());
      this.withDefaultDatastore(instance.getDefaultDatastore());
      this.withFolder(instance.getFolder());
      this.withNetwork(instance.getNetwork());
      this.withVCenter(instance.getVCenter());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private LocalObjectReferenceBuilder certificatesSecretRef;
  private String cluster;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private String datacenter;
  private String defaultDatastore;
  private String folder;
  private String network;
  private String vCenter;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCertificatesSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getCertificatesSecretRef() {
    return this.certificatesSecretRef!=null ?this.certificatesSecretRef.build():null;
  }
  public LocalObjectReference buildCertificatesSecretRef() {
    return this.certificatesSecretRef!=null ?this.certificatesSecretRef.build():null;
  }
  public A withCertificatesSecretRef(LocalObjectReference certificatesSecretRef) {
    _visitables.get("certificatesSecretRef").remove(this.certificatesSecretRef);
    if (certificatesSecretRef!=null){ this.certificatesSecretRef= new LocalObjectReferenceBuilder(certificatesSecretRef); _visitables.get("certificatesSecretRef").add(this.certificatesSecretRef);} else { this.certificatesSecretRef = null; _visitables.get("certificatesSecretRef").remove(this.certificatesSecretRef); } return (A) this;
  }
  public Boolean hasCertificatesSecretRef() {
    return this.certificatesSecretRef != null;
  }
  public A withNewCertificatesSecretRef(String name) {
    return (A)withCertificatesSecretRef(new LocalObjectReference(name));
  }
  public PlatformFluentImpl.CertificatesSecretRefNested<A> withNewCertificatesSecretRef() {
    return new PlatformFluentImpl.CertificatesSecretRefNestedImpl();
  }
  public PlatformFluentImpl.CertificatesSecretRefNested<A> withNewCertificatesSecretRefLike(LocalObjectReference item) {
    return new PlatformFluentImpl.CertificatesSecretRefNestedImpl(item);
  }
  public PlatformFluentImpl.CertificatesSecretRefNested<A> editCertificatesSecretRef() {
    return withNewCertificatesSecretRefLike(getCertificatesSecretRef());
  }
  public PlatformFluentImpl.CertificatesSecretRefNested<A> editOrNewCertificatesSecretRef() {
    return withNewCertificatesSecretRefLike(getCertificatesSecretRef() != null ? getCertificatesSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public PlatformFluentImpl.CertificatesSecretRefNested<A> editOrNewCertificatesSecretRefLike(LocalObjectReference item) {
    return withNewCertificatesSecretRefLike(getCertificatesSecretRef() != null ? getCertificatesSecretRef(): item);
  }
  public String getCluster() {
    return this.cluster;
  }
  public A withCluster(String cluster) {
    this.cluster=cluster; return (A) this;
  }
  public Boolean hasCluster() {
    return this.cluster != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCredentialsSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  public Boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new PlatformFluentImpl.CredentialsSecretRefNestedImpl();
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new PlatformFluentImpl.CredentialsSecretRefNestedImpl(item);
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef());
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public PlatformFluentImpl.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): item);
  }
  public String getDatacenter() {
    return this.datacenter;
  }
  public A withDatacenter(String datacenter) {
    this.datacenter=datacenter; return (A) this;
  }
  public Boolean hasDatacenter() {
    return this.datacenter != null;
  }
  public String getDefaultDatastore() {
    return this.defaultDatastore;
  }
  public A withDefaultDatastore(String defaultDatastore) {
    this.defaultDatastore=defaultDatastore; return (A) this;
  }
  public Boolean hasDefaultDatastore() {
    return this.defaultDatastore != null;
  }
  public String getFolder() {
    return this.folder;
  }
  public A withFolder(String folder) {
    this.folder=folder; return (A) this;
  }
  public Boolean hasFolder() {
    return this.folder != null;
  }
  public String getNetwork() {
    return this.network;
  }
  public A withNetwork(String network) {
    this.network=network; return (A) this;
  }
  public Boolean hasNetwork() {
    return this.network != null;
  }
  public String getVCenter() {
    return this.vCenter;
  }
  public A withVCenter(String vCenter) {
    this.vCenter=vCenter; return (A) this;
  }
  public Boolean hasVCenter() {
    return this.vCenter != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (!java.util.Objects.equals(certificatesSecretRef, that.certificatesSecretRef)) return false;

    if (!java.util.Objects.equals(cluster, that.cluster)) return false;

    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;

    if (!java.util.Objects.equals(datacenter, that.datacenter)) return false;

    if (!java.util.Objects.equals(defaultDatastore, that.defaultDatastore)) return false;

    if (!java.util.Objects.equals(folder, that.folder)) return false;

    if (!java.util.Objects.equals(network, that.network)) return false;

    if (!java.util.Objects.equals(vCenter, that.vCenter)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(certificatesSecretRef,  cluster,  credentialsSecretRef,  datacenter,  defaultDatastore,  folder,  network,  vCenter,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certificatesSecretRef != null) { sb.append("certificatesSecretRef:"); sb.append(certificatesSecretRef + ","); }
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (datacenter != null) { sb.append("datacenter:"); sb.append(datacenter + ","); }
    if (defaultDatastore != null) { sb.append("defaultDatastore:"); sb.append(defaultDatastore + ","); }
    if (folder != null) { sb.append("folder:"); sb.append(folder + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (vCenter != null) { sb.append("vCenter:"); sb.append(vCenter + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CertificatesSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<PlatformFluentImpl.CertificatesSecretRefNested<N>> implements PlatformFluentImpl.CertificatesSecretRefNested<N>,Nested<N>{
    CertificatesSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    CertificatesSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withCertificatesSecretRef(builder.build());
    }
    public N endCertificatesSecretRef() {
      return and();
    }
    
  }
  class CredentialsSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<PlatformFluentImpl.CredentialsSecretRefNested<N>> implements PlatformFluentImpl.CredentialsSecretRefNested<N>,Nested<N>{
    CredentialsSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    CredentialsSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withCredentialsSecretRef(builder.build());
    }
    public N endCredentialsSecretRef() {
      return and();
    }
    
  }
  
}