package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformStatusBuilder extends PlatformStatusFluent<PlatformStatusBuilder> implements VisitableBuilder<PlatformStatus,PlatformStatusBuilder>{
  public PlatformStatusBuilder() {
    this(false);
  }
  public PlatformStatusBuilder(Boolean validationEnabled) {
    this(new PlatformStatus(), validationEnabled);
  }
  public PlatformStatusBuilder(PlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformStatusBuilder(PlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlatformStatus(), validationEnabled);
  }
  public PlatformStatusBuilder(PlatformStatusFluent<?> fluent,PlatformStatus instance) {
    this(fluent, instance, false);
  }
  public PlatformStatusBuilder(PlatformStatusFluent<?> fluent,PlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PlatformStatus());

    if (instance != null) {
      fluent.withPrivateLink(instance.getPrivateLink());
      fluent.withPrivateLink(instance.getPrivateLink());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformStatusBuilder(PlatformStatus instance) {
    this(instance,false);
  }
  public PlatformStatusBuilder(PlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PlatformStatus());

    if (instance != null) {
      this.withPrivateLink(instance.getPrivateLink());
      this.withPrivateLink(instance.getPrivateLink());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PlatformStatus build() {
    PlatformStatus buildable = new PlatformStatus(fluent.buildPrivateLink());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}