package io.fabric8.openshift.api.model.hive.azure.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  public MachinePoolFluent(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());

    if (instance != null) {
      this.withOsDisk(instance.getOsDisk());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withOsDisk(instance.getOsDisk());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private OSDiskBuilder osDisk;
  private String type;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public OSDisk buildOsDisk() {
    return this.osDisk!=null ?this.osDisk.build():null;
  }
  public A withOsDisk(OSDisk osDisk) {
    _visitables.get("osDisk").remove(this.osDisk);
    if (osDisk!=null){ this.osDisk= new OSDiskBuilder(osDisk); _visitables.get("osDisk").add(this.osDisk);} else { this.osDisk = null; _visitables.get("osDisk").remove(this.osDisk); } return (A) this;
  }
  public boolean hasOsDisk() {
    return this.osDisk != null;
  }
  public A withNewOsDisk(Integer diskSizeGB) {
    return (A)withOsDisk(new OSDisk(diskSizeGB));
  }
  public OsDiskNested<A> withNewOsDisk() {
    return new OsDiskNested(null);
  }
  public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
    return new OsDiskNested(item);
  }
  public OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(null));
  }
  public OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(new OSDiskBuilder().build()));
  }
  public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(item));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A removeFromZones(java.lang.String... items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  public A removeAllFromZones(Collection<String> items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  public List<String> getZones() {
    return this.zones;
  }
  public String getZone(int index) {
    return this.zones.get(index);
  }
  public String getFirstZone() {
    return this.zones.get(0);
  }
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  public String getMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<String> zones) {
    if (zones != null) {this.zones = new ArrayList(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear(); _visitables.remove("zones"); }
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  public boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(osDisk, that.osDisk)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(zones, that.zones)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(osDisk,  type,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OsDiskNested<N> extends OSDiskFluent<OsDiskNested<N>> implements Nested<N>{
    OsDiskNested(OSDisk item) {
      this.builder = new OSDiskBuilder(this, item);
    }
    OSDiskBuilder builder;
    public N and() {
      return (N) MachinePoolFluent.this.withOsDisk(builder.build());
    }
    public N endOsDisk() {
      return and();
    }
    
  }
  
}