package io.fabric8.openshift.api.model.hive.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      fluent.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      fluent.withCloud(instance.getCloud());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withTrunkSupport(instance.getTrunkSupport());
      fluent.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      fluent.withCloud(instance.getCloud());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withTrunkSupport(instance.getTrunkSupport());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      this.withCloud(instance.getCloud());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withTrunkSupport(instance.getTrunkSupport());
      this.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      this.withCloud(instance.getCloud());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withTrunkSupport(instance.getTrunkSupport());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.buildCertificatesSecretRef(),fluent.getCloud(),fluent.buildCredentialsSecretRef(),fluent.getTrunkSupport());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}