package io.fabric8.openshift.api.model.hive.ovirt.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluent<A extends PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  public PlatformFluent(Platform instance) {
    instance = (instance != null ? instance : new Platform());

    if (instance != null) {
      this.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withOvirtClusterId(instance.getOvirtClusterId());
      this.withOvirtNetworkName(instance.getOvirtNetworkName());
      this.withStorageDomainId(instance.getStorageDomainId());
      this.withCertificatesSecretRef(instance.getCertificatesSecretRef());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withOvirtClusterId(instance.getOvirtClusterId());
      this.withOvirtNetworkName(instance.getOvirtNetworkName());
      this.withStorageDomainId(instance.getStorageDomainId());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private LocalObjectReferenceBuilder certificatesSecretRef;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private String ovirtClusterId;
  private String ovirtNetworkName;
  private String storageDomainId;
  private Map<String,Object> additionalProperties;
  public LocalObjectReference buildCertificatesSecretRef() {
    return this.certificatesSecretRef!=null ?this.certificatesSecretRef.build():null;
  }
  public A withCertificatesSecretRef(LocalObjectReference certificatesSecretRef) {
    _visitables.get("certificatesSecretRef").remove(this.certificatesSecretRef);
    if (certificatesSecretRef!=null){ this.certificatesSecretRef= new LocalObjectReferenceBuilder(certificatesSecretRef); _visitables.get("certificatesSecretRef").add(this.certificatesSecretRef);} else { this.certificatesSecretRef = null; _visitables.get("certificatesSecretRef").remove(this.certificatesSecretRef); } return (A) this;
  }
  public boolean hasCertificatesSecretRef() {
    return this.certificatesSecretRef != null;
  }
  public A withNewCertificatesSecretRef(String name) {
    return (A)withCertificatesSecretRef(new LocalObjectReference(name));
  }
  public CertificatesSecretRefNested<A> withNewCertificatesSecretRef() {
    return new CertificatesSecretRefNested(null);
  }
  public CertificatesSecretRefNested<A> withNewCertificatesSecretRefLike(LocalObjectReference item) {
    return new CertificatesSecretRefNested(item);
  }
  public CertificatesSecretRefNested<A> editCertificatesSecretRef() {
    return withNewCertificatesSecretRefLike(java.util.Optional.ofNullable(buildCertificatesSecretRef()).orElse(null));
  }
  public CertificatesSecretRefNested<A> editOrNewCertificatesSecretRef() {
    return withNewCertificatesSecretRefLike(java.util.Optional.ofNullable(buildCertificatesSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  public CertificatesSecretRefNested<A> editOrNewCertificatesSecretRefLike(LocalObjectReference item) {
    return withNewCertificatesSecretRefLike(java.util.Optional.ofNullable(buildCertificatesSecretRef()).orElse(item));
  }
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  public boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  public CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new CredentialsSecretRefNested(null);
  }
  public CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new CredentialsSecretRefNested(item);
  }
  public CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(null));
  }
  public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(java.util.Optional.ofNullable(buildCredentialsSecretRef()).orElse(item));
  }
  public String getOvirtClusterId() {
    return this.ovirtClusterId;
  }
  public A withOvirtClusterId(String ovirtClusterId) {
    this.ovirtClusterId=ovirtClusterId; return (A) this;
  }
  public boolean hasOvirtClusterId() {
    return this.ovirtClusterId != null;
  }
  public String getOvirtNetworkName() {
    return this.ovirtNetworkName;
  }
  public A withOvirtNetworkName(String ovirtNetworkName) {
    this.ovirtNetworkName=ovirtNetworkName; return (A) this;
  }
  public boolean hasOvirtNetworkName() {
    return this.ovirtNetworkName != null;
  }
  public String getStorageDomainId() {
    return this.storageDomainId;
  }
  public A withStorageDomainId(String storageDomainId) {
    this.storageDomainId=storageDomainId; return (A) this;
  }
  public boolean hasStorageDomainId() {
    return this.storageDomainId != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(certificatesSecretRef, that.certificatesSecretRef)) return false;

    if (!java.util.Objects.equals(credentialsSecretRef, that.credentialsSecretRef)) return false;

    if (!java.util.Objects.equals(ovirtClusterId, that.ovirtClusterId)) return false;

    if (!java.util.Objects.equals(ovirtNetworkName, that.ovirtNetworkName)) return false;

    if (!java.util.Objects.equals(storageDomainId, that.storageDomainId)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(certificatesSecretRef,  credentialsSecretRef,  ovirtClusterId,  ovirtNetworkName,  storageDomainId,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certificatesSecretRef != null) { sb.append("certificatesSecretRef:"); sb.append(certificatesSecretRef + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (ovirtClusterId != null) { sb.append("ovirtClusterId:"); sb.append(ovirtClusterId + ","); }
    if (ovirtNetworkName != null) { sb.append("ovirtNetworkName:"); sb.append(ovirtNetworkName + ","); }
    if (storageDomainId != null) { sb.append("storageDomainId:"); sb.append(storageDomainId + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CertificatesSecretRefNested<N> extends LocalObjectReferenceFluent<CertificatesSecretRefNested<N>> implements Nested<N>{
    CertificatesSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PlatformFluent.this.withCertificatesSecretRef(builder.build());
    }
    public N endCertificatesSecretRef() {
      return and();
    }
    
  }
  public class CredentialsSecretRefNested<N> extends LocalObjectReferenceFluent<CredentialsSecretRefNested<N>> implements Nested<N>{
    CredentialsSecretRefNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PlatformFluent.this.withCredentialsSecretRef(builder.build());
    }
    public N endCredentialsSecretRef() {
      return and();
    }
    
  }
  
}