package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSPrivateLinkConfigBuilder extends AWSPrivateLinkConfigFluent<AWSPrivateLinkConfigBuilder> implements VisitableBuilder<AWSPrivateLinkConfig,AWSPrivateLinkConfigBuilder>{
  public AWSPrivateLinkConfigBuilder() {
    this(false);
  }
  public AWSPrivateLinkConfigBuilder(Boolean validationEnabled) {
    this(new AWSPrivateLinkConfig(), validationEnabled);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSPrivateLinkConfig(), validationEnabled);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent,AWSPrivateLinkConfig instance) {
    this(fluent, instance, false);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent,AWSPrivateLinkConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSPrivateLinkConfig());

    if (instance != null) {
      fluent.withAssociatedVPCs(instance.getAssociatedVPCs());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withDnsRecordType(instance.getDnsRecordType());
      fluent.withEndpointVPCInventory(instance.getEndpointVPCInventory());
      fluent.withAssociatedVPCs(instance.getAssociatedVPCs());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withDnsRecordType(instance.getDnsRecordType());
      fluent.withEndpointVPCInventory(instance.getEndpointVPCInventory());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfig instance) {
    this(instance,false);
  }
  public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSPrivateLinkConfig());

    if (instance != null) {
      this.withAssociatedVPCs(instance.getAssociatedVPCs());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withDnsRecordType(instance.getDnsRecordType());
      this.withEndpointVPCInventory(instance.getEndpointVPCInventory());
      this.withAssociatedVPCs(instance.getAssociatedVPCs());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withDnsRecordType(instance.getDnsRecordType());
      this.withEndpointVPCInventory(instance.getEndpointVPCInventory());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSPrivateLinkConfigFluent<?> fluent;
  Boolean validationEnabled;
  public AWSPrivateLinkConfig build() {
    AWSPrivateLinkConfig buildable = new AWSPrivateLinkConfig(fluent.buildAssociatedVPCs(),fluent.buildCredentialsSecretRef(),fluent.getDnsRecordType(),fluent.buildEndpointVPCInventory());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}