package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSPrivateLinkSubnetBuilder extends AWSPrivateLinkSubnetFluent<AWSPrivateLinkSubnetBuilder> implements VisitableBuilder<AWSPrivateLinkSubnet,AWSPrivateLinkSubnetBuilder>{
  public AWSPrivateLinkSubnetBuilder() {
    this(false);
  }
  public AWSPrivateLinkSubnetBuilder(Boolean validationEnabled) {
    this(new AWSPrivateLinkSubnet(), validationEnabled);
  }
  public AWSPrivateLinkSubnetBuilder(AWSPrivateLinkSubnetFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPrivateLinkSubnetBuilder(AWSPrivateLinkSubnetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSPrivateLinkSubnet(), validationEnabled);
  }
  public AWSPrivateLinkSubnetBuilder(AWSPrivateLinkSubnetFluent<?> fluent,AWSPrivateLinkSubnet instance) {
    this(fluent, instance, false);
  }
  public AWSPrivateLinkSubnetBuilder(AWSPrivateLinkSubnetFluent<?> fluent,AWSPrivateLinkSubnet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSPrivateLinkSubnet());

    if (instance != null) {
      fluent.withAvailabilityZone(instance.getAvailabilityZone());
      fluent.withSubnetID(instance.getSubnetID());
      fluent.withAvailabilityZone(instance.getAvailabilityZone());
      fluent.withSubnetID(instance.getSubnetID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSPrivateLinkSubnetBuilder(AWSPrivateLinkSubnet instance) {
    this(instance,false);
  }
  public AWSPrivateLinkSubnetBuilder(AWSPrivateLinkSubnet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSPrivateLinkSubnet());

    if (instance != null) {
      this.withAvailabilityZone(instance.getAvailabilityZone());
      this.withSubnetID(instance.getSubnetID());
      this.withAvailabilityZone(instance.getAvailabilityZone());
      this.withSubnetID(instance.getSubnetID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSPrivateLinkSubnetFluent<?> fluent;
  Boolean validationEnabled;
  public AWSPrivateLinkSubnet build() {
    AWSPrivateLinkSubnet buildable = new AWSPrivateLinkSubnet(fluent.getAvailabilityZone(),fluent.getSubnetID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}