package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSResourceTagBuilder extends AWSResourceTagFluent<AWSResourceTagBuilder> implements VisitableBuilder<AWSResourceTag,AWSResourceTagBuilder>{
  public AWSResourceTagBuilder() {
    this(false);
  }
  public AWSResourceTagBuilder(Boolean validationEnabled) {
    this(new AWSResourceTag(), validationEnabled);
  }
  public AWSResourceTagBuilder(AWSResourceTagFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSResourceTagBuilder(AWSResourceTagFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSResourceTag(), validationEnabled);
  }
  public AWSResourceTagBuilder(AWSResourceTagFluent<?> fluent,AWSResourceTag instance) {
    this(fluent, instance, false);
  }
  public AWSResourceTagBuilder(AWSResourceTagFluent<?> fluent,AWSResourceTag instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSResourceTag());

    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withValue(instance.getValue());
      fluent.withKey(instance.getKey());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSResourceTagBuilder(AWSResourceTag instance) {
    this(instance,false);
  }
  public AWSResourceTagBuilder(AWSResourceTag instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSResourceTag());

    if (instance != null) {
      this.withKey(instance.getKey());
      this.withValue(instance.getValue());
      this.withKey(instance.getKey());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSResourceTagFluent<?> fluent;
  Boolean validationEnabled;
  public AWSResourceTag build() {
    AWSResourceTag buildable = new AWSResourceTag(fluent.getKey(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}