package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSServiceProviderCredentialsBuilder extends AWSServiceProviderCredentialsFluent<AWSServiceProviderCredentialsBuilder> implements VisitableBuilder<AWSServiceProviderCredentials,AWSServiceProviderCredentialsBuilder>{
  public AWSServiceProviderCredentialsBuilder() {
    this(false);
  }
  public AWSServiceProviderCredentialsBuilder(Boolean validationEnabled) {
    this(new AWSServiceProviderCredentials(), validationEnabled);
  }
  public AWSServiceProviderCredentialsBuilder(AWSServiceProviderCredentialsFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSServiceProviderCredentialsBuilder(AWSServiceProviderCredentialsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSServiceProviderCredentials(), validationEnabled);
  }
  public AWSServiceProviderCredentialsBuilder(AWSServiceProviderCredentialsFluent<?> fluent,AWSServiceProviderCredentials instance) {
    this(fluent, instance, false);
  }
  public AWSServiceProviderCredentialsBuilder(AWSServiceProviderCredentialsFluent<?> fluent,AWSServiceProviderCredentials instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSServiceProviderCredentials());

    if (instance != null) {
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSServiceProviderCredentialsBuilder(AWSServiceProviderCredentials instance) {
    this(instance,false);
  }
  public AWSServiceProviderCredentialsBuilder(AWSServiceProviderCredentials instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSServiceProviderCredentials());

    if (instance != null) {
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSServiceProviderCredentialsFluent<?> fluent;
  Boolean validationEnabled;
  public AWSServiceProviderCredentials build() {
    AWSServiceProviderCredentials buildable = new AWSServiceProviderCredentials(fluent.buildCredentialsSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}